/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.base.Function;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDF;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.services.functions.GetDefaultWorkspace;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceRdfContext
extends RdfStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkspaceRdfContext.class);
    private Function<Repository, String> getDefaultWorkspace = new GetDefaultWorkspace();

    public WorkspaceRdfContext(Session session, GraphSubjects subjects) throws RepositoryException {
        String[] workspaces = session.getWorkspace().getAccessibleWorkspaceNames();
        String defaultWorkspace = (String)this.getDefaultWorkspace.apply((Object)session.getRepository());
        Node repositorySubject = subjects.getGraphSubject("/").asNode();
        for (String workspace : workspaces) {
            Node resource = subjects.getGraphSubject("/workspace:" + workspace).asNode();
            LOGGER.debug("Discovered workspace: {}", (Object)resource);
            this.concat(Triple.create((Node)resource, (Node)RDF.type.asNode(), (Node)RdfLexicon.WORKSPACE_TYPE.asNode()));
            this.concat(Triple.create((Node)resource, (Node)RdfLexicon.DC_TITLE.asNode(), (Node)NodeFactory.createLiteral((String)workspace)));
            this.concat(Triple.create((Node)repositorySubject, (Node)RdfLexicon.HAS_WORKSPACE.asNode(), (Node)resource));
            if (!defaultWorkspace.equals(workspace)) continue;
            this.concat(Triple.create((Node)repositorySubject, (Node)RdfLexicon.HAS_DEFAULT_WORKSPACE.asNode(), (Node)resource));
        }
    }
}

