/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl.mappings;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.modeshape.jcr.api.Namespaced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDefinitionToTriples<T extends ItemDefinition>
implements Function<T, Iterator<Triple>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemDefinitionToTriples.class);
    private Node context;

    public ItemDefinitionToTriples(Node context) {
        this.context = context;
    }

    public Iterator<Triple> apply(T input) {
        try {
            Node propertyDefinitionNode = ItemDefinitionToTriples.getResource(input).asNode();
            LOGGER.trace("Adding triples for nodeType: {} with child nodes: {}", (Object)this.context.getURI(), (Object)propertyDefinitionNode.getURI());
            return new RdfStream(new Triple[]{Triple.create((Node)propertyDefinitionNode, (Node)RDF.type.asNode(), (Node)RDF.Property.asNode()), Triple.create((Node)propertyDefinitionNode, (Node)RDFS.domain.asNode(), (Node)this.context), Triple.create((Node)propertyDefinitionNode, (Node)RDFS.label.asNode(), (Node)NodeFactory.createLiteral((String)input.getName()))});
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Resource getResource(Namespaced namespacedObject) throws RepositoryException {
        LOGGER.trace("Creating RDF resource for {}:{}", (Object)namespacedObject.getNamespaceURI(), (Object)namespacedObject.getLocalName());
        return ResourceFactory.createProperty((String)JcrRdfTools.getRDFNamespaceForJcrNamespace(namespacedObject.getNamespaceURI()), (String)namespacedObject.getLocalName()).asResource();
    }

    public static Resource getResource(NodeType nodeType) throws RepositoryException {
        return ItemDefinitionToTriples.getResource((Namespaced)nodeType);
    }

    public static Resource getResource(ItemDefinition itemDefinition) throws RepositoryException {
        return ItemDefinitionToTriples.getResource((Namespaced)itemDefinition);
    }
}

