/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.FedoraResourceImpl;
import org.fcrepo.kernel.rdf.impl.NodeTypeRdfContext;
import org.fcrepo.kernel.services.AbstractService;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NodeServiceImpl
extends AbstractService
implements NodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeServiceImpl.class);

    @Override
    public FedoraResource findOrCreateObject(Session session, String path) throws RepositoryException {
        return new FedoraResourceImpl(this.findOrCreateNode(session, path));
    }

    @Override
    public FedoraResource getObject(Session session, String path) throws RepositoryException {
        return new FedoraResourceImpl(session.getNode(path));
    }

    @Override
    public FedoraResource getObject(Session session, String path, String versionId) throws RepositoryException {
        VersionHistory versionHistory = FedoraTypesUtils.getVersionHistory(session, path);
        if (versionHistory == null) {
            return null;
        }
        if (!versionHistory.hasVersionLabel(versionId)) {
            return null;
        }
        Version version = versionHistory.getVersionByLabel(versionId);
        return new FedoraResourceImpl(version.getFrozenNode());
    }

    @Override
    public Set<String> getObjectNames(Session session, String path) throws RepositoryException {
        return this.getObjectNames(session, path, null);
    }

    @Override
    public Set<String> getObjectNames(Session session, String path, String mixin) throws RepositoryException {
        Node objects = session.getNode(path);
        ImmutableSet.Builder b = ImmutableSet.builder();
        NodeIterator i = objects.getNodes();
        while (i.hasNext()) {
            Node n = i.nextNode();
            LOGGER.trace("Child of type {} is named {} at {}", new Object[]{n.getPrimaryNodeType(), n.getName(), n.getPath()});
            if (mixin != null && !n.isNodeType(mixin)) continue;
            b.add((Object)n.getName());
        }
        return b.build();
    }

    @Override
    public void deleteObject(Session session, String path) throws RepositoryException {
        Node obj = session.getNode(path);
        obj.remove();
    }

    @Override
    public void copyObject(Session session, String source, String destination) throws RepositoryException {
        session.getWorkspace().copy(source, destination);
    }

    @Override
    public void moveObject(Session session, String source, String destination) throws RepositoryException {
        session.getWorkspace().move(source, destination);
    }

    @Override
    public NodeTypeIterator getAllNodeTypes(Session session) throws RepositoryException {
        NodeTypeManager ntmanager = (NodeTypeManager)session.getWorkspace().getNodeTypeManager();
        return ntmanager.getAllNodeTypes();
    }

    @Override
    public RdfStream getNodeTypes(Session session) throws RepositoryException {
        return new NodeTypeRdfContext(session.getWorkspace().getNodeTypeManager());
    }

    @Override
    public void registerNodeTypes(Session session, InputStream cndStream) throws RepositoryException, IOException {
        NodeTypeManager nodeTypeManager = (NodeTypeManager)session.getWorkspace().getNodeTypeManager();
        nodeTypeManager.registerNodeTypes(cndStream, true);
    }
}

