/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.spring;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPropertiesLoader.class);
    private static final String SEP = System.getProperty("file.separator");

    public void loadSystemProperties() {
        LOGGER.info("Loading properties");
        if (System.getProperty("integration-test") == null) {
            LOGGER.trace("Setting default properties, if necessary.");
            String fcrepoHome = System.getProperty("fcrepo.home");
            String baseDir = fcrepoHome == null ? System.getProperty("user.dir") + SEP + "fcrepo4-data" + SEP : fcrepoHome + SEP;
            for (PROPERTIES prop : PROPERTIES.values()) {
                String value = System.getProperty(prop.getValue());
                if (value == null) {
                    this.setProperty(prop.getValue(), baseDir);
                    continue;
                }
                this.updateRelativePropertyPath(prop.getValue(), value, baseDir);
            }
        }
        for (PROPERTIES prop : PROPERTIES.values()) {
            String val = prop.getValue();
            LOGGER.info("{} = {}", (Object)val, (Object)System.getProperty(val));
        }
    }

    private void setProperty(String prop, String baseDir) {
        System.setProperty(prop, baseDir + prop);
    }

    private void updateRelativePropertyPath(String prop, String value, String baseDir) {
        if (!new File(value).isAbsolute()) {
            System.setProperty(prop, baseDir + value);
        }
    }

    private static enum PROPERTIES {
        DEFAULT_OBJECT_STORE("com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean.default.objectStoreDir"),
        OBJECT_STORE("com.arjuna.ats.arjuna.objectstore.objectStoreDir"),
        ISPN_CACHE("fcrepo.ispn.CacheDirPath"),
        ISPN_BIN_CACHE("fcrepo.ispn.binary.CacheDirPath"),
        BIN_STORE_PATH("fcrepo.binary-store-path"),
        MODE_INDEX("fcrepo.modeshape.index.location"),
        ISPN_ALT_CACHE("fcrepo.ispn.alternative.CacheDirPath"),
        ISPN_BIN_ALT_CACHE("fcrepo.ispn.binary.alternative.CacheDirPath"),
        ISPN_REPO_CACHE("fcrepo.ispn.repo.CacheDirPath"),
        ACTIVE_MQ("fcrepo.activemq.dir");

        private String text;

        private PROPERTIES(String text) {
            this.text = text;
        }

        public String getValue() {
            return this.text;
        }
    }
}

