/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import java.net.URI;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.fcrepo.kernel.utils.CacheEntry;
import org.fcrepo.kernel.utils.FixityResult;

public class FixityResultImpl
implements FixityResult {
    private final Set<FixityResult.FixityState> status = EnumSet.noneOf(FixityResult.FixityState.class);
    private long computedSize;
    private URI computedChecksum;
    private final CacheEntry entry;

    public FixityResultImpl() {
        this(null);
    }

    public FixityResultImpl(CacheEntry entry) {
        this.entry = entry;
    }

    public FixityResultImpl(long size, URI checksum) {
        this(null, size, checksum);
    }

    public FixityResultImpl(CacheEntry entry, long size, URI checksum) {
        this.entry = entry;
        this.computedSize = size;
        this.computedChecksum = checksum;
    }

    @Override
    public String getStoreIdentifier() {
        return this.entry.getExternalIdentifier();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof FixityResult) {
            FixityResult that = (FixityResult)obj;
            result = this.computedSize == that.getComputedSize() && this.computedChecksum.equals(that.getComputedChecksum());
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.computedSize, this.computedChecksum);
    }

    public String toString() {
        return "Fixity: checksum: " + this.computedChecksum + " / " + Long.toString(this.computedSize);
    }

    @Override
    public CacheEntry getEntry() {
        return this.entry;
    }

    @Override
    public boolean matches(URI checksum) {
        return this.computedChecksum.equals(checksum);
    }

    @Override
    public boolean matches(long size) {
        return this.computedSize == size;
    }

    @Override
    public boolean matches(long size, URI checksum) {
        return this.matches(size) && this.matches(checksum);
    }

    @Override
    public boolean isSuccess() {
        return this.status.contains((Object)FixityResult.FixityState.SUCCESS);
    }

    @Override
    public void setRepaired() {
        this.status.add(FixityResult.FixityState.REPAIRED);
    }

    @Override
    public Set<FixityResult.FixityState> getStatus() {
        return this.status;
    }

    @Override
    public long getComputedSize() {
        return this.computedSize;
    }

    @Override
    public URI getComputedChecksum() {
        return this.computedChecksum;
    }
}

