/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.iterators;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.kernel.exception.MalformedRdfException;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.rdf.ManagedRdf;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.kernel.utils.iterators.RdfStreamConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistingRdfStreamConsumer
implements RdfStreamConsumer {
    private final RdfStream stream;
    private final GraphSubjects idTranslator;
    private final Session session;
    private final JcrRdfTools jcrRdfTools;
    protected final Predicate<Triple> isFedoraSubjectTriple;
    private static final Model m = ModelFactory.createDefaultModel();
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistingRdfStreamConsumer.class);

    public PersistingRdfStreamConsumer(final GraphSubjects graphSubjects, Session session, RdfStream stream) {
        this.idTranslator = graphSubjects;
        this.jcrRdfTools = JcrRdfTools.withContext(graphSubjects, session);
        this.isFedoraSubjectTriple = new Predicate<Triple>(){

            public boolean apply(Triple t) {
                boolean result = graphSubjects.isFedoraGraphSubject(m.asStatement(t).getSubject());
                if (result) {
                    LOGGER.debug("Discovered a Fedora-relevant subject in triple: {}.", (Object)t);
                } else {
                    LOGGER.debug("Ignoring triple: {}.", (Object)t);
                }
                return result;
            }
        };
        this.stream = stream.withThisContext(stream.filter((Predicate<? super Triple>)Predicates.and((Predicate)Predicates.not(ManagedRdf.isManagedTriple), this.isFedoraSubjectTriple)).iterator());
        this.session = session;
    }

    @Override
    public void consume() throws RepositoryException {
        while (this.stream.hasNext()) {
            Statement t = m.asStatement((Triple)this.stream.next());
            LOGGER.debug("Operating on triple {}.", (Object)t);
            this.operateOnTriple(t);
        }
    }

    protected void operateOnTriple(Statement t) throws RepositoryException {
        Resource subject = t.getSubject();
        Node subjectNode = this.idTranslator().getNodeFromGraphSubject(subject);
        if (t.getPredicate().equals(RDF.type) && t.getObject().isResource()) {
            Resource mixinResource = t.getObject().asResource();
            if (!ManagedRdf.isManagedMixin.apply((Object)mixinResource)) {
                LOGGER.debug("Operating on node: {} with mixin: {}.", (Object)subjectNode, (Object)mixinResource);
                this.operateOnMixin(mixinResource, subjectNode);
            } else {
                LOGGER.debug("Found repository-managed mixin on which we will not operate.");
            }
        } else {
            LOGGER.debug("Operating on node: {} from triple: {}.", (Object)subjectNode, (Object)t);
            this.operateOnProperty(t, subjectNode);
        }
    }

    protected String getPropertyNameFromPredicate(Node subjectNode, Property predicate) throws RepositoryException {
        return this.jcrRdfTools().getPropertyNameFromPredicate(subjectNode, predicate, this.stream.namespaces());
    }

    protected Value createValue(Node subjectNode, RDFNode object, Integer propertyType) throws RepositoryException {
        return this.jcrRdfTools().createValue(subjectNode, object, (int)propertyType);
    }

    protected String jcrMixinNameFromRdfResource(Resource mixinResource) throws RepositoryException {
        String namespace = JcrRdfTools.getJcrNamespaceForRDFNamespace(mixinResource.getNameSpace());
        String namespacePrefix = null;
        Map streamNSMap = (Map)Preconditions.checkNotNull(this.stream().namespaces(), (Object)"Use an empty map of namespaces, not null!");
        if (streamNSMap.containsValue(namespace)) {
            LOGGER.debug("Found namespace: {} in stream namespace mapping.", (Object)namespace);
            for (Map.Entry entry : streamNSMap.entrySet()) {
                String streamNamespace = (String)entry.getValue();
                if (!namespace.equals(streamNamespace)) continue;
                LOGGER.debug("Found namespace: {} in stream namespace mapping with prefix: {}.", (Object)namespace, (Object)namespacePrefix);
                namespacePrefix = (String)entry.getKey();
            }
        } else {
            try {
                namespacePrefix = this.session().getNamespacePrefix(namespace);
                LOGGER.debug("Found namespace: {} in repository namespace mapping with prefix: {}.", (Object)namespace, (Object)namespacePrefix);
            }
            catch (NamespaceException e) {
                throw new MalformedRdfException("Unable to resolve registered namespace for resource " + mixinResource.toString(), (Throwable)e);
            }
        }
        String mixinName = namespacePrefix + ":" + mixinResource.getLocalName();
        LOGGER.debug("Constructed JCR mixin name: {}", (Object)mixinName);
        return mixinName;
    }

    protected abstract void operateOnProperty(Statement var1, Node var2) throws RepositoryException;

    protected abstract void operateOnMixin(Resource var1, Node var2) throws RepositoryException;

    @Override
    public ListenableFuture<Boolean> consumeAsync() {
        SettableFuture result = SettableFuture.create();
        try {
            this.consume();
            result.set((Object)true);
        }
        catch (Exception e) {
            LOGGER.warn("Got exception consuming RDF stream", (Throwable)e);
            result.setException((Throwable)e);
            result.set((Object)false);
        }
        return result;
    }

    public RdfStream stream() {
        return this.stream;
    }

    public GraphSubjects idTranslator() {
        return this.idTranslator;
    }

    public Session session() {
        return this.session;
    }

    public JcrRdfTools jcrRdfTools() {
        return this.jcrRdfTools;
    }
}

