/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.RepositoryLockManager;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.LockFailureException;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;

@ThreadSafe
class JcrLockManager
implements LockManager {
    private final JcrSession session;
    private final RepositoryLockManager lockManager;
    private final ConcurrentMap<String, Object> lockTokens = new ConcurrentHashMap<String, Object>();

    JcrLockManager(JcrSession session, RepositoryLockManager lockManager) {
        this.session = session;
        this.lockManager = lockManager;
    }

    boolean hasLockToken(String token) {
        return this.lockTokens.containsKey(token);
    }

    final void cleanLocks() throws RepositoryException {
        this.lockManager.cleanLocks(this.session);
        this.lockTokens.clear();
    }

    public void addLockToken(String lockToken) throws LockException {
        CheckArg.isNotNull((Object)lockToken, (String)"lockToken");
        if (this.lockTokens.containsKey(lockToken)) {
            return;
        }
        try {
            if (!this.lockManager.setHeldBySession(this.session, lockToken, true)) {
                throw new LockException(JcrI18n.lockTokenAlreadyHeld.text(new Object[]{lockToken}));
            }
            this.lockTokens.putIfAbsent(lockToken, lockToken);
        }
        catch (LockException e) {
            this.lockTokens.remove(lockToken);
            throw e;
        }
    }

    public void removeLockToken(String lockToken) throws LockException {
        CheckArg.isNotNull((Object)lockToken, (String)"lockToken");
        if (!this.lockTokens.containsKey(lockToken)) {
            throw new LockException(JcrI18n.invalidLockToken.text(new Object[]{lockToken}));
        }
        try {
            if (!this.lockManager.setHeldBySession(this.session, lockToken, false)) {
                throw new LockException(JcrI18n.invalidLockToken.text(new Object[]{lockToken}));
            }
            this.lockTokens.remove(lockToken);
        }
        catch (LockFailureException e) {
            this.lockTokens.remove(lockToken);
            throw new LockException(JcrI18n.invalidLockToken.text(new Object[]{lockToken}));
        }
    }

    Set<String> lockTokens() {
        return Collections.unmodifiableSet(this.lockTokens.keySet());
    }

    public String[] getLockTokens() {
        HashSet<String> tokens = new HashSet<String>();
        for (String token : this.lockTokens.keySet()) {
            RepositoryLockManager.ModeShapeLock lock = this.lockManager.findLockByToken(token);
            if (lock == null || lock.isSessionScoped()) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public boolean isLocked(String absPath) throws PathNotFoundException, RepositoryException {
        return this.getLowestLockAlongPath(this.session.node(this.session.absolutePathFor(absPath))) != null;
    }

    public boolean isLocked(AbstractJcrNode node) throws PathNotFoundException, RepositoryException {
        return this.getLowestLockAlongPath(node) != null;
    }

    public Lock getLock(String absPath) throws PathNotFoundException, LockException, AccessDeniedException, RepositoryException {
        RepositoryLockManager.ModeShapeLock lock = this.getLowestLockAlongPath(this.session.node(this.session.absolutePathFor(absPath)));
        if (lock != null) {
            return lock.lockFor(this.session);
        }
        throw new LockException(JcrI18n.notLocked.text(new Object[]{absPath}));
    }

    public Lock getLock(AbstractJcrNode node) throws LockException, AccessDeniedException, RepositoryException {
        RepositoryLockManager.ModeShapeLock lock = this.getLowestLockAlongPath(node);
        if (lock != null) {
            return lock.lockFor(this.session);
        }
        throw new LockException(JcrI18n.notLocked.text(new Object[]{node.getPath()}));
    }

    public Lock getLockIfExists(AbstractJcrNode node) throws AccessDeniedException, RepositoryException {
        RepositoryLockManager.ModeShapeLock lock = this.getLowestLockAlongPath(node);
        return lock == null ? null : lock.lockFor(this.session);
    }

    public RepositoryLockManager.ModeShapeLock getLowestLockAlongPath(AbstractJcrNode node) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        NodeKey nodeKey;
        SessionCache sessionCache;
        this.session.checkLive();
        SessionCache cache = sessionCache = this.session.cache();
        NodeKey key = nodeKey = node.key();
        while (key != null) {
            RepositoryLockManager.ModeShapeLock lock = this.lockManager.findLockFor(key);
            if (lock != null && (lock.isDeep() || nodeKey.equals((Object)lock.getLockedNodeKey()))) {
                return lock;
            }
            CachedNode cachedNode = cache.getNode(key);
            if (cachedNode == null) {
                if (sessionCache == cache) {
                    cache = sessionCache.getWorkspace();
                    cachedNode = cache.getNode(key);
                }
                if (cachedNode == null) break;
            }
            key = cachedNode.getParentKey((NodeCache)cache);
        }
        return null;
    }

    public boolean holdsLock(String absPath) throws PathNotFoundException, RepositoryException {
        AbstractJcrNode node = this.session.node(this.session.absolutePathFor(absPath));
        return this.lockManager.findLockFor(node.key()) != null;
    }

    public boolean holdsLock(AbstractJcrNode node) {
        return this.lockManager.findLockFor(node.key()) != null;
    }

    public Lock lock(String absPath, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws LockException, PathNotFoundException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        AbstractJcrNode node = this.session.node(this.session.absolutePathFor(absPath));
        return this.lock(node, isDeep, isSessionScoped, timeoutHint, ownerInfo);
    }

    public Lock lock(AbstractJcrNode node, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        if (!node.isLockable()) {
            throw new LockException(JcrI18n.nodeNotLockable.text(new Object[]{node.location()}));
        }
        if (node.isNew() || node.isModified()) {
            throw new InvalidItemStateException(JcrI18n.changedNodeCannotBeLocked.text(new Object[]{node.location()}));
        }
        RepositoryLockManager.ModeShapeLock lock = this.lockManager.lock(this.session, node.node(), isDeep, isSessionScoped, timeoutHint, ownerInfo);
        String token = lock.getLockToken();
        this.lockTokens.put(token, token);
        return lock.lockFor(this.session);
    }

    public void unlock(String absPath) throws PathNotFoundException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        AbstractJcrNode node = this.session.node(this.session.absolutePathFor(absPath));
        this.unlock(node);
    }

    public void unlock(AbstractJcrNode node) throws PathNotFoundException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        if (node.isModified()) {
            throw new InvalidItemStateException(JcrI18n.changedNodeCannotBeUnlocked.text(new Object[]{node.getPath()}));
        }
        RepositoryLockManager.ModeShapeLock lock = this.lockManager.findLockFor(node.key());
        if (lock != null && !this.lockTokens.containsKey(lock.getLockToken())) {
            try {
                this.session.checkPermission(this.session.workspaceName(), node.path(), "unlock_any");
            }
            catch (AccessDeniedException e) {
                throw new LockException((Throwable)e);
            }
        }
        String lockToken = this.lockManager.unlock(this.session, node.key());
        this.lockTokens.remove(lockToken);
    }
}

