/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.CndImporter;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.SystemContent;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.SessionCache;

public class Upgrades {
    protected static final Logger LOGGER = Logger.getLogger(Upgrades.class);
    protected static final int EMPTY_UPGRADES_ID = 0;
    public static final Upgrades STANDARD_UPGRADES = new Upgrades(ModeShape_3_6_0.INSTANCE);
    private final List<UpgradeOperation> operations = new ArrayList<UpgradeOperation>();

    protected Upgrades(UpgradeOperation ... operations) {
        int maxId = 0;
        for (UpgradeOperation op : operations) {
            assert (op.getId() > maxId) : "Upgrade operation '" + op + "' has an out-of-order ID ('" + op.getId() + "') that must be greater than all prior upgrades";
            maxId = op.getId();
            this.operations.add(op);
        }
    }

    public final int applyUpgradesSince(int lastId, Context resources) {
        int lastUpgradeId = lastId;
        for (UpgradeOperation op : this.operations) {
            if (op.getId() <= lastId) continue;
            LOGGER.debug("Upgrade {0}: starting", new Object[]{op});
            op.apply(resources);
            LOGGER.debug("Upgrade {0}: complete", new Object[]{op});
            lastUpgradeId = op.getId();
        }
        return lastUpgradeId;
    }

    public final boolean isUpgradeRequired(int lastId) {
        return this.getLatestAvailableUpgradeId() > lastId;
    }

    public final int getLatestAvailableUpgradeId() {
        return this.operations.isEmpty() ? 0 : this.operations.get(this.operations.size() - 1).getId();
    }

    protected static class ModeShape_3_6_0
    extends UpgradeOperation {
        protected static final UpgradeOperation INSTANCE = new ModeShape_3_6_0();

        protected ModeShape_3_6_0() {
            super(1);
        }

        @Override
        public void apply(Context resources) {
            LOGGER.info((I18nResource)JcrI18n.upgrade3_6_0Running, new Object[0]);
            JcrRepository.RunningState repository = resources.getRepository();
            if (this.updateInternalNodeTypes(repository)) {
                this.updateLocks(repository);
            }
        }

        private void updateLocks(JcrRepository.RunningState repository) {
            try {
                SessionCache systemSession = repository.createSystemSession(repository.context(), false);
                SystemContent systemContent = new SystemContent(systemSession);
                CachedNode locksNode = systemContent.locksNode();
                if (locksNode == null) {
                    return;
                }
                ChildReferences childReferences = locksNode.getChildReferences((NodeCache)systemSession);
                if (childReferences.isEmpty()) {
                    return;
                }
                for (ChildReference ref : childReferences) {
                    MutableCachedNode lockNode = systemSession.mutable(ref.getKey());
                    lockNode.removeProperty(systemSession, ModeShapeLexicon.LOCKED_KEY);
                    lockNode.removeProperty(systemSession, ModeShapeLexicon.SESSION_SCOPE);
                    lockNode.removeProperty(systemSession, ModeShapeLexicon.IS_DEEP);
                }
                systemContent.save();
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e, (I18nResource)JcrI18n.upgrade3_6_0CannotUpdateLocks, new Object[]{e.getMessage()});
            }
        }

        private boolean updateInternalNodeTypes(JcrRepository.RunningState repository) {
            CndImporter importer = new CndImporter(repository.context(), true);
            SimpleProblems problems = new SimpleProblems();
            try {
                importer.importFrom(this.getClass().getClassLoader().getResourceAsStream("org/modeshape/jcr/modeshape_builtins.cnd"), (Problems)problems, null);
                if (!problems.isEmpty()) {
                    LOGGER.error((I18nResource)JcrI18n.upgrade3_6_0CannotUpdateNodeTypes, new Object[]{problems.toString()});
                    return false;
                }
                ArrayList<NodeTypeDefinition> nodeTypeDefinitions = new ArrayList<NodeTypeDefinition>(importer.getNodeTypeDefinitions());
                Iterator nodeTypeDefinitionIterator = nodeTypeDefinitions.iterator();
                while (nodeTypeDefinitionIterator.hasNext()) {
                    NodeTypeDefinition nodeTypeDefinition = (NodeTypeDefinition)nodeTypeDefinitionIterator.next();
                    String name = nodeTypeDefinition.getName();
                    if (ModeShapeLexicon.ACCESS_CONTROLLABLE.getString().equalsIgnoreCase(name) || ModeShapeLexicon.ACL.getString().equalsIgnoreCase(name) || ModeShapeLexicon.PERMISSION.getString().equalsIgnoreCase(name) || ModeShapeLexicon.LOCK.getString().equalsIgnoreCase(name)) continue;
                    nodeTypeDefinitionIterator.remove();
                }
                repository.nodeTypeManager().registerNodeTypes(nodeTypeDefinitions, false, false, true);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e, (I18nResource)JcrI18n.upgrade3_6_0CannotUpdateNodeTypes, new Object[]{e.getMessage()});
                return false;
            }
            return true;
        }
    }

    protected static abstract class UpgradeOperation {
        private final int id;

        protected UpgradeOperation(int id) {
            assert (id > 0) : "An upgrade operation's identifier must be positive";
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public abstract void apply(Context var1);

        public String toString() {
            return this.getClass().getSimpleName() + "(step " + this.id + ")";
        }
    }

    public static interface Context {
        public JcrRepository.RunningState getRepository();

        public Problems getProblems();
    }
}

