/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.fcrepo.integration.kernel.AbstractIT;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.utils.ContentDigest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class DatastreamImplIT
extends AbstractIT {
    @Inject
    Repository repo;
    @Inject
    DatastreamService datastreamService;
    @Inject
    ObjectService objectService;

    @Test
    public void testCreatedDate() throws RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testDatastreamObject");
        this.datastreamService.createDatastream(session, "/testDatastreamObject/testDatastreamNode1", "application/octet-stream", null, (InputStream)new ByteArrayInputStream("asdf".getBytes()));
        session.save();
        session.logout();
        session = this.repo.login();
        Datastream ds = this.datastreamService.getDatastream(session, "/testDatastreamObject/testDatastreamNode1");
        Assert.assertNotNull((String)"Couldn't find created date on datastream!", (Object)ds.getCreatedDate());
    }

    @Test
    public void testDatastreamContent() throws IOException, RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testDatastreamObject");
        this.datastreamService.createDatastream(session, "/testDatastreamObject/testDatastreamNode1", "application/octet-stream", null, (InputStream)new ByteArrayInputStream("asdf".getBytes()));
        session.save();
        Datastream ds = this.datastreamService.getDatastream(session, "/testDatastreamObject/testDatastreamNode1");
        String contentString = IOUtils.toString((InputStream)ds.getContent(), (String)"ASCII");
        Assert.assertEquals((Object)"asdf", (Object)contentString);
    }

    @Test
    public void testDatastreamContentDigestAndLength() throws IOException, RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testDatastreamObject");
        this.datastreamService.createDatastream(session, "/testDatastreamObject/testDatastreamNode2", "application/octet-stream", null, (InputStream)new ByteArrayInputStream("asdf".getBytes()));
        session.save();
        Datastream ds = this.datastreamService.getDatastream(session, "/testDatastreamObject/testDatastreamNode2");
        Assert.assertEquals((Object)"urn:sha1:3da541559918a808c2402bba5012f6c60b27661c", (Object)ds.getContentDigest().toString());
        Assert.assertEquals((long)4L, (long)ds.getContentSize());
        String contentString = IOUtils.toString((InputStream)ds.getContent(), (String)"ASCII");
        Assert.assertEquals((Object)"asdf", (Object)contentString);
    }

    @Test
    public void testModifyDatastreamContentDigestAndLength() throws IOException, RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testDatastreamObject");
        this.datastreamService.createDatastream(session, "/testDatastreamObject/testDatastreamNode3", "application/octet-stream", null, (InputStream)new ByteArrayInputStream("asdf".getBytes()));
        session.save();
        Datastream ds = this.datastreamService.getDatastream(session, "/testDatastreamObject/testDatastreamNode3");
        ds.setContent((InputStream)new ByteArrayInputStream("0123456789".getBytes()));
        Assert.assertEquals((Object)"urn:sha1:87acec17cd9dcd20a716cc2cf67417b71c8a7016", (Object)ds.getContentDigest().toString());
        Assert.assertEquals((long)10L, (long)ds.getContentSize());
        String contentString = IOUtils.toString((InputStream)ds.getContent(), (String)"ASCII");
        Assert.assertEquals((Object)"0123456789", (Object)contentString);
    }

    @Test
    public void testDatastreamContentWithChecksum() throws IOException, RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testDatastreamObject");
        this.datastreamService.createDatastream(session, "/testDatastreamObject/testDatastreamNode4", "application/octet-stream", null, (InputStream)new ByteArrayInputStream("asdf".getBytes()), ContentDigest.asURI((String)"SHA-1", (String)"3da541559918a808c2402bba5012f6c60b27661c"));
        session.save();
        Datastream ds = this.datastreamService.getDatastream(session, "/testDatastreamObject/testDatastreamNode4");
        Assert.assertEquals((Object)"urn:sha1:3da541559918a808c2402bba5012f6c60b27661c", (Object)ds.getContentDigest().toString());
        String contentString = IOUtils.toString((InputStream)ds.getContent(), (String)"ASCII");
        Assert.assertEquals((Object)"asdf", (Object)contentString);
    }

    @Test
    public void testDatastreamFileName() throws RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testDatastreamObject");
        this.datastreamService.createDatastream(session, "/testDatastreamObject/testDatastreamNode5", "application/octet-stream", "xyz.jpg", (InputStream)new ByteArrayInputStream("asdf".getBytes()));
        session.save();
        Datastream ds = this.datastreamService.getDatastream(session, "/testDatastreamObject/testDatastreamNode5");
        String filename = ds.getFilename();
        Assert.assertEquals((Object)"xyz.jpg", (Object)filename);
    }
}

