/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.impl.NamespaceRdfContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.NamespaceRegistry;

public class NamespaceContextTest {
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    private static final String testUri = "http://example.com";
    private static final String prefix = "jcr";
    private static Predicate<Triple> hasTestUriAsObject = new Predicate<Triple>(){

        public boolean apply(Triple t) {
            return t.objectMatches(NodeFactory.createLiteral((String)NamespaceContextTest.testUri));
        }
    };

    @Test(expected=NullPointerException.class)
    public void testBadNamespaceRegistry() throws RepositoryException {
        this.mockNamespaceRegistry = null;
        new NamespaceRdfContext(this.mockSession);
    }

    @Test
    public void testConstructor() throws RepositoryException {
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefixes()).thenReturn((Object)new String[]{prefix, ""});
        Mockito.when((Object)this.mockNamespaceRegistry.getURI("")).thenReturn((Object)"GARBAGE URI FOR FAKE NAMESPACE, SHOULD NEVER BE PARSED");
        Mockito.when((Object)this.mockNamespaceRegistry.getURI(prefix)).thenReturn((Object)testUri);
        Assert.assertTrue((boolean)Iterators.any((Iterator)new NamespaceRdfContext(this.mockSession), hasTestUriAsObject));
    }

    @Test
    public void testJcrUris() throws RepositoryException {
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefixes()).thenReturn((Object)new String[]{prefix});
        Mockito.when((Object)this.mockNamespaceRegistry.getURI(prefix)).thenReturn((Object)"http://www.jcp.org/jcr/1.0");
        Assert.assertTrue((boolean)new NamespaceRdfContext(this.mockSession).asModel().contains(ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#"), RdfLexicon.HAS_NAMESPACE_URI, "http://fedora.info/definitions/v4/repository#"));
    }

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
    }
}

