/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.collect.ImmutableSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.rdf.impl.PropertiesRdfContext;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesRdfContextTest {
    private static final String MOCK_EXTERNAL_IDENTIFIER = "info:external-identifier";
    private static final Resource mockContentSubject = ResourceFactory.createResource((String)"http://example.com/node/jcr:content");
    private static final Resource mockSubject = ResourceFactory.createResource((String)"http://example.com/node");
    private static final String mockNodeTypePrefix = "jcr";
    private static final String mockNodeName = "mockNode";
    @Mock
    private Node mockNode;
    @Mock
    private Node mockContentNode;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private IdentifierTranslator mockGraphSubjects;
    @Mock
    private LowLevelStorageService mockLowLevelStorageService;
    @Mock
    private Session mockSession;
    @Mock
    private Repository mockRepository;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    @Mock
    private LowLevelCacheEntry mockLowLevelCacheEntry;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesRdfContextTest.class);

    @Test
    public void testForLowLevelStorageTriples() throws RepositoryException, IOException {
        Model results = new PropertiesRdfContext(this.mockNode, this.mockGraphSubjects, this.mockLowLevelStorageService).asModel();
        PropertiesRdfContextTest.logRdf("Retrieved RDF for testForLowLevelStorageTriples():", results);
        Assert.assertTrue((String)"Didn't find triple showing node has content!", (boolean)results.contains(mockSubject, RdfLexicon.HAS_CONTENT, (RDFNode)mockContentSubject));
        Assert.assertTrue((String)"Didn't find triple showing content has node!", (boolean)results.contains(mockContentSubject, RdfLexicon.IS_CONTENT_OF, (RDFNode)mockSubject));
        Assert.assertTrue((String)"Didn't find triple showing content has location!", (boolean)results.contains(mockContentSubject, RdfLexicon.HAS_CONTENT_LOCATION, (RDFNode)ResourceFactory.createResource((String)MOCK_EXTERNAL_IDENTIFIER)));
    }

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/mockNode");
        Mockito.when((Object)this.mockContentNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)this.mockNamespaceRegistry.getURI(mockNodeTypePrefix)).thenReturn((Object)"http://www.jcp.org/jcr/1.0");
        Mockito.when((Object)this.mockNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getNode("jcr:content")).thenReturn((Object)this.mockContentNode);
        Mockito.when((Object)this.mockNode.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockContentNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockContentNode.hasProperties()).thenReturn((Object)false);
        Mockito.when((Object)this.mockLowLevelStorageService.getLowLevelCacheEntries(this.mockContentNode)).thenReturn((Object)ImmutableSet.of((Object)this.mockLowLevelCacheEntry));
        Mockito.when((Object)this.mockLowLevelCacheEntry.getExternalIdentifier()).thenReturn((Object)MOCK_EXTERNAL_IDENTIFIER);
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockNode.getPath())).thenReturn((Object)mockSubject);
        Mockito.when((Object)this.mockGraphSubjects.getSubject(this.mockContentNode.getPath())).thenReturn((Object)mockContentSubject);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockContentNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.getSupertypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
        Mockito.when((Object)this.mockNodeType.getName()).thenReturn((Object)"jcr:mockNode");
    }

    private static void logRdf(String message, Model model) throws IOException {
        LOGGER.debug(message);
        try (StringWriter w = new StringWriter();){
            model.write((Writer)w);
            LOGGER.debug("\n" + ((Object)w).toString());
        }
    }
}

