/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.fcrepo.kernel.Lock;
import org.fcrepo.kernel.services.LockServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class LockServiceImplTest {
    private static final String LOCKABLE_PATH = "test1";
    private static final String ALREADY_LOCKED_PATH = "test2";
    private static final long TIMEOUT = -1L;
    private static final String USER = "user";
    private static final String LOCK_TOKEN = "token";
    private LockServiceImpl testObj;
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private LockManager mockLockManager;
    @Mock
    private javax.jcr.lock.Lock mockLock;
    @Mock
    private javax.jcr.lock.Lock otherMockLock;

    @Before
    public void setUp() throws RepositoryException {
        this.testObj = new LockServiceImpl();
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockSession.getUserID()).thenReturn((Object)USER);
        Mockito.when((Object)this.mockWorkspace.getLockManager()).thenReturn((Object)this.mockLockManager);
        Mockito.when((Object)this.mockLockManager.getLock(LOCKABLE_PATH)).thenReturn((Object)this.mockLock);
        Mockito.when((Object)this.mockLockManager.getLock(ALREADY_LOCKED_PATH)).thenReturn((Object)this.otherMockLock);
        Mockito.when((Object)this.mockLockManager.lock(LOCKABLE_PATH, false, false, -1L, USER)).thenReturn((Object)this.mockLock);
        Mockito.when((Object)this.mockLockManager.lock(ALREADY_LOCKED_PATH, false, false, -1L, USER)).thenThrow(new Class[]{LockException.class});
        Mockito.when((Object)this.mockLockManager.isLocked(ALREADY_LOCKED_PATH)).thenReturn((Object)true);
        Mockito.when((Object)this.mockLock.getLockToken()).thenReturn((Object)LOCK_TOKEN);
        Mockito.when((Object)this.mockLock.isDeep()).thenReturn((Object)false);
        Mockito.when((Object)this.otherMockLock.isDeep()).thenReturn((Object)false);
    }

    @Test
    public void testAcquireLock() throws RepositoryException {
        Lock lock = this.testObj.acquireLock(this.mockSession, LOCKABLE_PATH, false);
        Assert.assertEquals((Object)LOCK_TOKEN, (Object)lock.getLockToken());
        Assert.assertFalse((boolean)lock.isDeep());
    }

    @Test(expected=LockException.class)
    public void testAcquireLockFailure() throws RepositoryException {
        Lock lock = this.testObj.acquireLock(this.mockSession, ALREADY_LOCKED_PATH, false);
    }

    @Test
    public void testGetOwnedLock() throws RepositoryException {
        Mockito.when((Object)this.mockLockManager.isLocked(LOCKABLE_PATH)).thenReturn((Object)true);
        Lock lock = this.testObj.getLock(this.mockSession, LOCKABLE_PATH);
        Assert.assertEquals((Object)LOCK_TOKEN, (Object)lock.getLockToken());
        Assert.assertFalse((boolean)lock.isDeep());
    }

    @Test
    public void testReleaseOwnedLock() throws RepositoryException {
        Mockito.when((Object)this.mockLockManager.isLocked(LOCKABLE_PATH)).thenReturn((Object)true);
        this.testObj.releaseLock(this.mockSession, LOCKABLE_PATH);
        ((LockManager)Mockito.verify((Object)this.mockLockManager)).unlock(LOCKABLE_PATH);
    }

    @Test
    public void testReleaseOtherLock() throws RepositoryException {
        this.testObj.releaseLock(this.mockSession, ALREADY_LOCKED_PATH);
        ((LockManager)Mockito.verify((Object)this.mockLockManager)).unlock(ALREADY_LOCKED_PATH);
    }
}

