/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.exception.TransactionMissingException;
import org.fcrepo.kernel.services.TransactionService;
import org.fcrepo.kernel.services.TransactionServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TransactionServiceImplTest {
    private static final String IS_A_TX = "foo";
    private static final String NOT_A_TX = "bar";
    private static final String USER_NAME = "test";
    TransactionService service;
    @Mock
    private Transaction mockTx;
    @Mock
    private Session mockSession;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.service = new TransactionServiceImpl();
        Mockito.when((Object)this.mockTx.getId()).thenReturn((Object)IS_A_TX);
        Field txsField = TransactionServiceImpl.class.getDeclaredField("transactions");
        txsField.setAccessible(true);
        Map txs = (Map)txsField.get(TransactionService.class);
        txs.put(IS_A_TX, this.mockTx);
    }

    @Test
    public void testExpiration() throws Exception {
        Date fiveSecondsAgo = new Date(System.currentTimeMillis() - 5000L);
        Mockito.when((Object)this.mockTx.getExpires()).thenReturn((Object)fiveSecondsAgo);
        this.service.removeAndRollbackExpired();
        ((Transaction)Mockito.verify((Object)this.mockTx)).rollback();
    }

    @Test
    public void testExpirationThrowsRepositoryException() throws Exception {
        Date fiveSecondsAgo = new Date(System.currentTimeMillis() - 5000L);
        ((Transaction)Mockito.doThrow((Throwable)new RepositoryException("")).when((Object)this.mockTx)).rollback();
        Mockito.when((Object)this.mockTx.getExpires()).thenReturn((Object)fiveSecondsAgo);
        this.service.removeAndRollbackExpired();
    }

    @Test
    public void testCreateTx() throws Exception {
        Transaction tx = this.service.beginTransaction(this.mockSession, USER_NAME);
        Assert.assertNotNull((Object)tx);
        Assert.assertNotNull((Object)tx.getCreated());
        Assert.assertNotNull((Object)tx.getId());
        Assert.assertTrue((boolean)tx.isAssociatedWithUser(USER_NAME));
        Assert.assertEquals((Object)Transaction.State.NEW, (Object)tx.getState());
    }

    @Test
    public void testGetTx() throws Exception {
        Transaction tx = this.service.getTransaction(IS_A_TX);
        Assert.assertNotNull((Object)tx);
    }

    @Test(expected=TransactionMissingException.class)
    public void testGetNonTx() throws TransactionMissingException {
        this.service.getTransaction(NOT_A_TX);
    }

    @Test
    public void testGetTxForSession() throws Exception {
        Mockito.when((Object)this.mockSession.getNamespaceURI("fcrepo4.tx.id")).thenReturn((Object)IS_A_TX);
        Transaction tx = this.service.getTransaction(this.mockSession);
        Assert.assertEquals((Object)IS_A_TX, (Object)tx.getId());
    }

    @Test(expected=TransactionMissingException.class)
    public void testGetTxForNonTxSession() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getNamespaceURI("fcrepo4.tx.id")).thenThrow(new Throwable[]{new NamespaceException("")});
        this.service.getTransaction(this.mockSession);
    }

    @Test
    public void testExists() throws Exception {
        Assert.assertTrue((boolean)this.service.exists(IS_A_TX));
        Assert.assertFalse((boolean)this.service.exists(NOT_A_TX));
    }

    @Test
    public void testCommitTx() throws Exception {
        Transaction tx = this.service.commit(IS_A_TX);
        Assert.assertNotNull((Object)tx);
        ((Transaction)Mockito.verify((Object)this.mockTx)).commit(null);
    }

    @Test(expected=RepositoryException.class)
    public void testCommitRemovedTransaction() throws Exception {
        Transaction tx = this.service.commit(IS_A_TX);
        this.service.getTransaction(tx.getId());
    }

    @Test
    public void testRollbackTx() throws Exception {
        Transaction tx = this.service.rollback(IS_A_TX);
        Assert.assertNotNull((Object)tx);
        ((Transaction)Mockito.verify((Object)this.mockTx)).rollback();
    }

    @Test(expected=RepositoryException.class)
    public void testRollbackRemovedTransaction() throws Exception {
        Transaction tx = this.service.rollback(IS_A_TX);
        this.service.getTransaction(tx.getId());
    }

    @Test(expected=RepositoryException.class)
    public void testRollbackWithNonTx() throws RepositoryException {
        this.service.rollback(NOT_A_TX);
    }

    @Test(expected=RepositoryException.class)
    public void testCommitWithNonTx() throws RepositoryException {
        this.service.commit(NOT_A_TX);
    }
}

