/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services.functions;

import com.google.common.base.Function;
import java.lang.reflect.Field;
import org.fcrepo.kernel.services.functions.CacheLocalTransform;
import org.fcrepo.kernel.services.functions.GetCacheStore;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.impl.CacheStoreEntry;
import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.loaders.CacheStore;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.value.BinaryKey;

public class CacheLocalTransformTest {
    @Mock
    private GetCacheStore cacheExtractor;
    @Mock
    private CacheStore mockCacheStore;
    @Mock
    private Function<LowLevelCacheEntry, Object> mockTransform;
    @Mock
    private CacheImpl<Object, Object> mockCache;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testTransform() throws Exception {
        Field field = CacheLocalTransform.class.getDeclaredField("transform");
        field.setAccessible(true);
        field.set(CacheLocalTransform.class, this.cacheExtractor);
        Mockito.when((Object)this.cacheExtractor.apply((Cache)Matchers.any(Cache.class))).thenReturn((Object)this.mockCacheStore);
        BinaryKey key = new BinaryKey("key-123");
        CacheLocalTransform testObj = new CacheLocalTransform(key, this.mockTransform);
        Mockito.when((Object)this.mockCache.getName()).thenReturn((Object)"foo");
        testObj.setEnvironment(this.mockCache, null);
        testObj.call();
        ((Function)Mockito.verify(this.mockTransform)).apply(Matchers.eq((Object)new CacheStoreEntry(this.mockCacheStore, "foo", key)));
    }
}

