/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collections;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeTypeManager;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.utils.JcrPropertyStatementListener;
import org.fcrepo.kernel.utils.NodePropertiesTools;
import org.fcrepo.kernel.utils.TestHelpers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={JcrRdfTools.class})
public class JcrPropertyStatementListenerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrPropertyStatementListenerTest.class);
    private JcrPropertyStatementListener testObj;
    @Mock
    private Node mockNode;
    @Mock
    private Session mockSession;
    @Mock
    private IdentifierTranslator mockSubjects;
    @Mock
    private Statement mockStatement;
    @Mock
    private Resource mockSubject;
    @Mock
    private Property mockPredicate;
    @Mock
    private Node mockSubjectNode;
    @Mock
    private Model mockProblems;
    @Mock
    private JcrRdfTools mockJcrRdfTools;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NodeTypeManager mockNodeTypeManager;
    @Mock
    private Model mockModel;
    private Map<String, String> mockNsMapping = Collections.emptyMap();
    @Mock
    private NodePropertiesTools mockPropertiesTools;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)JcrRdfTools.withContext((IdentifierTranslator)this.mockSubjects, (Session)this.mockSession)).thenReturn((Object)this.mockJcrRdfTools);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        this.testObj = JcrPropertyStatementListener.getListener((IdentifierTranslator)this.mockSubjects, (Session)this.mockSession, (Model)this.mockProblems);
        Mockito.when((Object)this.mockStatement.getSubject()).thenReturn((Object)this.mockSubject);
        Mockito.when((Object)this.mockStatement.getPredicate()).thenReturn((Object)this.mockPredicate);
        TestHelpers.setField(this.testObj, "propertiesTools", this.mockPropertiesTools);
        Mockito.when((Object)this.mockStatement.getModel()).thenReturn((Object)this.mockModel);
        Mockito.when((Object)this.mockModel.getNsPrefixMap()).thenReturn(this.mockNsMapping);
    }

    @Test
    public void testAddedIrrelevantStatement() {
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(this.mockSubject)).thenReturn((Object)false);
        this.testObj.addedStatement(this.mockStatement);
        ((Model)Mockito.verify((Object)this.mockProblems, (VerificationMode)Mockito.never())).add((Resource)Matchers.any(Resource.class), (Property)Matchers.any(Property.class), (String)Matchers.any(String.class));
    }

    @Test
    public void testAddedProhibitedStatement() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(this.mockSubject)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.mockSubjects.getPathFromSubject(this.mockSubject))).thenReturn((Object)this.mockSubjectNode);
        Mockito.when((Object)this.mockJcrRdfTools.isInternalProperty(this.mockSubjectNode, (Resource)this.mockPredicate)).thenReturn((Object)true);
        Mockito.when((Object)this.mockPredicate.getURI()).thenReturn((Object)"x");
        this.testObj.addedStatement(this.mockStatement);
        ((Model)Mockito.verify((Object)this.mockProblems)).add((Resource)Matchers.any(Resource.class), (Property)Matchers.eq((Object)RdfLexicon.COULD_NOT_STORE_PROPERTY), (String)Matchers.eq((Object)"x"));
    }

    @Test
    public void testAddedStatement() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(this.mockSubject)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.mockSubjects.getPathFromSubject(this.mockSubject))).thenReturn((Object)this.mockSubjectNode);
        String mockPropertyName = "mock:property";
        Mockito.when((Object)this.mockJcrRdfTools.getPropertyNameFromPredicate(this.mockSubjectNode, this.mockPredicate, this.mockNsMapping)).thenReturn((Object)"mock:property");
        Mockito.when((Object)this.mockPropertiesTools.getPropertyType(this.mockSubjectNode, "mock:property")).thenReturn((Object)1);
        this.testObj.addedStatement(this.mockStatement);
        ((Model)Mockito.verify((Object)this.mockProblems, (VerificationMode)Mockito.times((int)0))).add((Resource)Matchers.any(Resource.class), (Property)Matchers.any(Property.class), (String)Matchers.any(String.class));
        LOGGER.debug("Finished testAddedStatement()");
    }

    @Test(expected=RuntimeException.class)
    public void testAddedStatementRepositoryException() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(this.mockSubject)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.mockSubjects.getPathFromSubject(this.mockSubject))).thenReturn((Object)this.mockSubjectNode);
        Mockito.when((Object)this.mockJcrRdfTools.getPropertyNameFromPredicate(this.mockSubjectNode, this.mockPredicate, this.mockNsMapping)).thenThrow(new Throwable[]{new RepositoryException()});
        this.testObj.addedStatement(this.mockStatement);
        ((Model)Mockito.verify((Object)this.mockProblems, (VerificationMode)Mockito.times((int)0))).add((Resource)Matchers.any(Resource.class), (Property)Matchers.any(Property.class), (String)Matchers.any(String.class));
    }

    @Test
    public void testRemovedStatement() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(this.mockSubject)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.mockSubjects.getPathFromSubject(this.mockSubject))).thenReturn((Object)this.mockSubjectNode);
        String mockPropertyName = "mock:property";
        Mockito.when((Object)this.mockJcrRdfTools.getPropertyNameFromPredicate(this.mockSubjectNode, this.mockPredicate)).thenReturn((Object)"mock:property");
        Mockito.when((Object)this.mockSubjectNode.hasProperty("mock:property")).thenReturn((Object)true);
        Mockito.when((Object)this.mockPropertiesTools.getPropertyType(this.mockSubjectNode, "mock:property")).thenReturn((Object)1);
        this.testObj.removedStatement(this.mockStatement);
        ((Model)Mockito.verify((Object)this.mockProblems, (VerificationMode)Mockito.times((int)0))).add((Resource)Matchers.any(Resource.class), (Property)Matchers.any(Property.class), (String)Matchers.any(String.class));
    }

    @Test(expected=RuntimeException.class)
    public void testRemovedStatementRepositoryException() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(this.mockSubject)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.mockSubjects.getPathFromSubject(this.mockSubject))).thenReturn((Object)this.mockSubjectNode);
        Mockito.when((Object)this.mockJcrRdfTools.getPropertyNameFromPredicate(this.mockSubjectNode, this.mockPredicate)).thenThrow(new Throwable[]{new RepositoryException()});
        this.testObj.removedStatement(this.mockStatement);
        ((Model)Mockito.verify((Object)this.mockProblems, (VerificationMode)Mockito.times((int)0))).add((Resource)Matchers.any(Resource.class), (Property)Matchers.any(Property.class), (String)Matchers.any(String.class));
    }

    @Test
    public void testRemovedProhibitedStatement() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(this.mockSubject)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.mockSubjects.getPathFromSubject(this.mockSubject))).thenReturn((Object)this.mockSubjectNode);
        Mockito.when((Object)this.mockPredicate.getURI()).thenReturn((Object)"x");
        String mockPropertyName = "jcr:property";
        Mockito.when((Object)this.mockJcrRdfTools.getPropertyNameFromPredicate(this.mockSubjectNode, this.mockPredicate)).thenReturn((Object)"jcr:property");
        Mockito.when((Object)this.mockJcrRdfTools.isInternalProperty(this.mockSubjectNode, (Resource)this.mockPredicate)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSubjectNode.hasProperty("jcr:property")).thenReturn((Object)true);
        Mockito.when((Object)this.mockPropertiesTools.getPropertyType(this.mockSubjectNode, "jcr:property")).thenReturn((Object)1);
        this.testObj.removedStatement(this.mockStatement);
        ((Model)Mockito.verify((Object)this.mockProblems)).add((Resource)Matchers.any(Resource.class), (Property)Matchers.eq((Object)RdfLexicon.COULD_NOT_STORE_PROPERTY), (String)Matchers.eq((Object)"x"));
    }

    @Test
    public void testRemovedIrrelevantStatement() {
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(this.mockSubject)).thenReturn((Object)false);
        this.testObj.removedStatement(this.mockStatement);
        ((Model)Mockito.verify((Object)this.mockProblems, (VerificationMode)Mockito.times((int)0))).add((Resource)Matchers.any(Resource.class), (Property)Matchers.any(Property.class), (String)Matchers.any(String.class));
    }

    @Test
    public void testAddRdfType() throws RepositoryException {
        Resource resource = ResourceFactory.createResource();
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(resource)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.mockSubjects.getPathFromSubject(resource))).thenReturn((Object)this.mockSubjectNode);
        Mockito.when((Object)this.mockSubjectNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.hasNodeType("fedora:object")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNamespacePrefix("http://fedora.info/definitions/v4/rest-api#")).thenReturn((Object)"fedora");
        Model model = ModelFactory.createDefaultModel();
        model.add(resource, RDF.type, (RDFNode)model.createResource("http://fedora.info/definitions/v4/rest-api#object"));
        Mockito.when((Object)this.mockSubjectNode.canAddMixin("fedora:object")).thenReturn((Object)true);
        this.testObj.addedStatements(model);
        ((Node)Mockito.verify((Object)this.mockSubjectNode)).addMixin("fedora:object");
    }

    @Test
    public void testRemoveRdfType() throws RepositoryException {
        Resource resource = ResourceFactory.createResource();
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(resource)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.mockSubjects.getPathFromSubject(resource))).thenReturn((Object)this.mockSubjectNode);
        Mockito.when((Object)this.mockSubjectNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.hasNodeType("fedora:object")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNamespacePrefix("http://fedora.info/definitions/v4/rest-api#")).thenReturn((Object)"fedora");
        Model model = ModelFactory.createDefaultModel();
        model.add(resource, RDF.type, (RDFNode)model.createResource("http://fedora.info/definitions/v4/rest-api#object"));
        this.testObj.removedStatements(model);
        ((Node)Mockito.verify((Object)this.mockSubjectNode)).removeMixin("fedora:object");
    }

    @Test
    public void testAddRdfTypeForNonMixin() throws RepositoryException {
        Resource resource = ResourceFactory.createResource();
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(resource)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.mockSubjects.getPathFromSubject(resource))).thenReturn((Object)this.mockSubjectNode);
        Mockito.when((Object)this.mockSubjectNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.hasNodeType("fedora:object")).thenReturn((Object)false);
        Mockito.when((Object)this.mockPropertiesTools.getPropertyType(this.mockSubjectNode, "rdf:type")).thenReturn((Object)11);
        Mockito.when((Object)this.mockSession.getNamespacePrefix("http://fedora.info/definitions/v4/rest-api#")).thenReturn((Object)"fedora");
        Model model = ModelFactory.createDefaultModel();
        model.add(resource, RDF.type, (RDFNode)model.createResource("http://fedora.info/definitions/v4/rest-api#object"));
        Mockito.when((Object)this.mockSubjectNode.canAddMixin("fedora:object")).thenReturn((Object)true);
        this.testObj.addedStatements(model);
        ((Node)Mockito.verify((Object)this.mockSubjectNode, (VerificationMode)Mockito.never())).addMixin("fedora:object");
        ((Model)Mockito.verify((Object)this.mockProblems, (VerificationMode)Mockito.times((int)0))).add((Resource)Matchers.any(Resource.class), (Property)Matchers.any(Property.class), (String)Matchers.any(String.class));
    }

    @Test
    public void testRemoveRdfTypeForNonMixin() throws RepositoryException {
        Resource resource = ResourceFactory.createResource();
        Mockito.when((Object)this.mockSubjects.isFedoraGraphSubject(resource)).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode(this.mockSubjects.getPathFromSubject(resource))).thenReturn((Object)this.mockSubjectNode);
        Mockito.when((Object)this.mockSubjectNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.hasNodeType("fedora:object")).thenReturn((Object)false);
        Mockito.when((Object)this.mockSession.getNamespacePrefix("http://fedora.info/definitions/v4/rest-api#")).thenReturn((Object)"fedora");
        Model model = ModelFactory.createDefaultModel();
        model.add(resource, RDF.type, (RDFNode)model.createResource("http://fedora.info/definitions/v4/rest-api#object"));
        this.testObj.removedStatements(model);
        ((Node)Mockito.verify((Object)this.mockSubjectNode, (VerificationMode)Mockito.never())).removeMixin("fedora:object");
        ((Model)Mockito.verify((Object)this.mockProblems, (VerificationMode)Mockito.times((int)0))).add((Resource)Matchers.any(Resource.class), (Property)Matchers.any(Property.class), (String)Matchers.any(String.class));
    }
}

