/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jcr.Session;
import javax.jcr.lock.LockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class LockReleasingSession
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockReleasingSession.class);
    private final Session session;

    public LockReleasingSession(Session session) {
        this.session = session;
    }

    public static Session newInstance(Session session) {
        LOGGER.trace("Wrapping session {} ({}).", (Object)session, (Object)session.getClass().getName());
        return (Session)Proxy.newProxyInstance(session.getClass().getClassLoader(), ClassUtils.getAllInterfaces((Object)session), (InvocationHandler)new LockReleasingSession(session));
    }

    public Session getWrappedSession() {
        return this.session;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (name.equals("logout")) {
            LOGGER.trace("Intercepted session.logout()");
            if (this.session.isLive()) {
                LockManager lockManager = this.session.getWorkspace().getLockManager();
                for (String token : lockManager.getLockTokens()) {
                    LOGGER.trace("Removing lock token {}.", (Object)token);
                    lockManager.removeLockToken(token);
                }
            }
        }
        return this.delegate(method, args);
    }

    private Object delegate(Method method, Object[] args) throws Throwable {
        Object invocationResult;
        try {
            invocationResult = method.invoke((Object)this.session, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return invocationResult;
    }
}

