/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.TxAwareSession;
import org.fcrepo.kernel.services.VersionService;

public class TransactionImpl
implements Transaction {
    public static final long DEFAULT_TIMEOUT = 180000L;
    public static final String TIMEOUT_SYSTEM_PROPERTY = "fcrepo4.tx.timeout";
    private final Session session;
    private final String id;
    private final String userName;
    private final Date created;
    private final Calendar expires;
    private Transaction.State state = Transaction.State.NEW;
    private Set<String> versionedPaths;

    public TransactionImpl(Session session, String userName) {
        this.session = session;
        this.created = new Date();
        this.id = UUID.randomUUID().toString();
        this.expires = Calendar.getInstance();
        this.updateExpiryDate();
        this.userName = userName;
    }

    @Override
    public Session getSession() {
        this.updateExpiryDate();
        return TxAwareSession.newInstance(this.session, this.id);
    }

    @Override
    public Date getCreated() {
        return new Date(this.created.getTime());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Transaction.State getState() throws RepositoryException {
        if (this.session != null && this.session.hasPendingChanges()) {
            return Transaction.State.DIRTY;
        }
        return this.state;
    }

    @Override
    public Date getExpires() {
        return this.expires.getTime();
    }

    @Override
    public void addPathToVersion(String absPath) {
        if (this.versionedPaths == null) {
            this.versionedPaths = Collections.newSetFromMap(new ConcurrentHashMap());
        }
        this.versionedPaths.add(absPath);
    }

    @Override
    public void commit(VersionService vService) throws RepositoryException {
        this.session.save();
        if (this.versionedPaths != null) {
            if (vService == null) {
                throw new IllegalStateException("Versioned Paths were added, but no VersionService was provided!");
            }
            vService.createVersion(this.session.getWorkspace(), this.versionedPaths);
        }
        this.state = Transaction.State.COMMITED;
        this.expire();
    }

    @Override
    public void expire() {
        this.session.logout();
        this.expires.setTimeInMillis(System.currentTimeMillis());
    }

    @Override
    public boolean isAssociatedWithUser(String userName) {
        boolean associatedWith = false;
        if (this.userName == null) {
            if (userName == null) {
                associatedWith = true;
            }
        } else {
            associatedWith = this.userName.equals(userName);
        }
        return associatedWith;
    }

    @Override
    public void rollback() throws RepositoryException {
        this.state = Transaction.State.ROLLED_BACK;
        this.session.refresh(false);
        this.expire();
    }

    @Override
    public void updateExpiryDate() {
        long duration = System.getProperty(TIMEOUT_SYSTEM_PROPERTY) != null ? Long.parseLong(System.getProperty(TIMEOUT_SYSTEM_PROPERTY)) : 180000L;
        this.expires.setTimeInMillis(System.currentTimeMillis() + duration);
    }
}

