/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jcr.Session;
import org.fcrepo.kernel.TxSession;

public class TxAwareSession
implements InvocationHandler {
    private final String txId;
    private final Session session;

    public TxAwareSession(Session session, String txID) {
        this.session = session;
        this.txId = txID;
    }

    public static Session newInstance(Session session, String txId) {
        return (Session)Proxy.newProxyInstance(session.getClass().getClassLoader(), new Class[]{TxSession.class}, (InvocationHandler)new TxAwareSession(session, txId));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object invocationResult;
        String name = method.getName();
        if (name.equals("logout") || name.equals("save")) {
            return null;
        }
        if (name.equals("getTxId")) {
            return this.txId;
        }
        try {
            invocationResult = method.invoke((Object)this.session, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        if (name.equals("impersonate")) {
            return TxAwareSession.newInstance((Session)invocationResult, this.txId);
        }
        return invocationResult;
    }
}

