/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.identifiers;

import com.google.common.base.Converter;
import com.google.common.collect.Lists;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.identifiers.InternalIdentifierConverter;

public class ExternalIdentifierConverter
extends IdentifierConverter<Resource> {
    @Inject
    protected List<InternalIdentifierConverter> translationChain;
    protected Converter<String, String> forward = ExternalIdentifierConverter.identity();
    protected Converter<String, String> reverse = ExternalIdentifierConverter.identity();

    protected Resource doForward(String a) {
        return this.doRdfForward((String)this.forward.convert((Object)a));
    }

    protected String doBackward(Resource a) {
        return (String)this.reverse.convert((Object)this.doRdfBackward(a));
    }

    protected Resource doRdfForward(String a) {
        return ResourceFactory.createResource((String)a);
    }

    protected String doRdfBackward(Resource a) {
        return a.toString();
    }

    @PostConstruct
    public void accumulateTranslations() {
        for (InternalIdentifierConverter t : this.translationChain) {
            this.forward = this.forward.andThen((Converter)t);
        }
        for (InternalIdentifierConverter t : Lists.reverse(this.translationChain)) {
            this.reverse = this.reverse.andThen(t.reverse());
        }
    }

    public void setTranslationChain(List<InternalIdentifierConverter> chain) {
        this.translationChain = chain;
        this.accumulateTranslations();
    }
}

