/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.eventbus.EventBus;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.fcrepo.kernel.observer.EventFilter;
import org.fcrepo.kernel.observer.eventmappings.InternalExternalEventMapper;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.api.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleObserver
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleObserver.class);
    static final Counter EVENT_COUNTER = RegistryService.getMetrics().counter(MetricRegistry.name(SimpleObserver.class, (String[])new String[]{"onEvent"}));
    static final Integer EVENT_TYPES = 63;
    @Inject
    private Repository repository;
    @Inject
    private EventBus eventBus;
    @Inject
    private InternalExternalEventMapper eventMapper;
    @Inject
    private EventFilter eventFilter;
    private Session session;

    @PostConstruct
    public void buildListener() throws RepositoryException {
        LOGGER.debug("Constructing an observer for JCR events...");
        this.session = this.repository.login();
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, EVENT_TYPES.intValue(), "/", true, null, null, false);
        this.session.save();
    }

    @PreDestroy
    public void stopListening() throws RepositoryException {
        LOGGER.debug("Destroying an observer for JCR events...");
        this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        this.session.logout();
    }

    public void onEvent(EventIterator events) {
        Session lookupSession = null;
        try {
            lookupSession = this.repository.login();
            UnmodifiableIterator filteredEvents = Iterators.filter((Iterator)events, this.eventFilter.getFilter(lookupSession));
            Iterator publishableEvents = (Iterator)this.eventMapper.apply(filteredEvents);
            while (publishableEvents.hasNext()) {
                this.eventBus.post(publishableEvents.next());
                EVENT_COUNTER.inc();
            }
        }
        catch (RepositoryException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        finally {
            if (lookupSession != null) {
                lookupSession.logout();
            }
        }
    }
}

