/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.base.Preconditions;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.rdf.IdentifierTranslator;

public class DefaultIdentifierTranslator
implements IdentifierTranslator {
    public static final String RESOURCE_NAMESPACE = "info:fedora/";
    private final Resource context = ResourceFactory.createResource();

    @Override
    public Resource getSubject(String absPath) throws RepositoryException {
        if (absPath.endsWith("jcr:content")) {
            return ResourceFactory.createResource((String)(RESOURCE_NAMESPACE + absPath.replace("jcr:content", "fcr:content").substring(1)));
        }
        return ResourceFactory.createResource((String)(RESOURCE_NAMESPACE + absPath.substring(1)));
    }

    @Override
    public Resource getContext() {
        return this.context;
    }

    @Override
    public String getPathFromSubject(Resource subject) throws RepositoryException {
        if (!this.isFedoraGraphSubject(subject)) {
            return null;
        }
        String absPath = subject.getURI().substring(RESOURCE_NAMESPACE.length() - 1);
        if (absPath.endsWith("fcr:content")) {
            return absPath.replace("fcr:content", "jcr:content");
        }
        return absPath;
    }

    @Override
    public boolean isFedoraGraphSubject(Resource subject) {
        Preconditions.checkNotNull((Object)subject, (Object)"null cannot be a Fedora object!");
        return subject.isURIResource() && subject.getURI().startsWith(RESOURCE_NAMESPACE);
    }
}

