/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl.mappings;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Iterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyToTriple
implements Function<Property, Function<Iterator<Value>, Iterator<Triple>>> {
    private IdentifierTranslator graphSubjects;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyToTriple.class);

    public PropertyToTriple(IdentifierTranslator graphSubjects) {
        this.graphSubjects = graphSubjects;
    }

    public Function<Iterator<Value>, Iterator<Triple>> apply(final Property p) {
        return new Function<Iterator<Value>, Iterator<Triple>>(){

            public Iterator<Triple> apply(Iterator<Value> vs) {
                return Iterators.transform(vs, (Function)new Function<Value, Triple>(){

                    public Triple apply(Value v) {
                        return PropertyToTriple.this.propertyvalue2triple(p, v);
                    }
                });
            }
        };
    }

    private Triple propertyvalue2triple(Property p, Value v) {
        LOGGER.trace("Rendering triple for Property: {} with Value: {}", (Object)p, (Object)v);
        try {
            Triple triple = Triple.create((Node)this.getGraphSubject(p.getParent()), (Node)((com.hp.hpl.jena.rdf.model.Property)JcrRdfTools.getPredicateForProperty.apply((Object)p)).asNode(), (Node)this.propertyvalue2node(p, v));
            LOGGER.trace("Created triple: {} ", (Object)triple);
            return triple;
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Node propertyvalue2node(Property p, Value v) {
        try {
            switch (v.getType()) {
                case 6: {
                    return PropertyToTriple.literal2node(v.getString());
                }
                case 5: {
                    return PropertyToTriple.literal2node(v.getDate());
                }
                case 12: {
                    return PropertyToTriple.literal2node(v.getDecimal());
                }
                case 4: {
                    return PropertyToTriple.literal2node(v.getDouble());
                }
                case 3: {
                    return PropertyToTriple.literal2node(v.getLong());
                }
                case 11: {
                    return ResourceFactory.createResource((String)v.getString()).asNode();
                }
                case 8: 
                case 9: 
                case 10: {
                    return this.traverseLink(p, v);
                }
            }
            return PropertyToTriple.literal2node(v.getString());
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Node literal2node(Object literal) {
        Node result = ResourceFactory.createTypedLiteral((Object)literal).asNode();
        LOGGER.trace("Converting {} into {}", literal, (Object)result);
        return result;
    }

    private Node traverseLink(Property p, Value v) throws RepositoryException {
        javax.jcr.Node refNode = v.getType() == 8 ? p.getParent().getNode(v.getString()) : p.getSession().getNodeByIdentifier(v.getString());
        return this.getGraphSubject(refNode);
    }

    private Node getGraphSubject(javax.jcr.Node n) throws RepositoryException {
        return this.graphSubjects.getSubject(n.getPath()).asNode();
    }
}

