/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockManager;
import org.fcrepo.kernel.Lock;
import org.fcrepo.kernel.services.AbstractService;
import org.fcrepo.kernel.services.LockService;
import org.springframework.stereotype.Component;

@Component
public class LockServiceImpl
extends AbstractService
implements LockService {
    @Override
    public Lock acquireLock(Session session, String path, boolean deep) throws RepositoryException {
        LockManager lockManager = session.getWorkspace().getLockManager();
        return new JCRLock(lockManager.lock(path, deep, false, -1L, session.getUserID()));
    }

    @Override
    public Lock getLock(Session session, String path) throws RepositoryException {
        LockManager lockManager = session.getWorkspace().getLockManager();
        if (!lockManager.isLocked(path)) {
            throw new PathNotFoundException("No lock at path " + path + "!");
        }
        return new JCRLock(lockManager.getLock(path));
    }

    @Override
    public void releaseLock(Session session, String path) throws RepositoryException {
        LockManager lockManager = session.getWorkspace().getLockManager();
        if (!lockManager.isLocked(path)) {
            throw new PathNotFoundException("No lock at path " + path + "!");
        }
        session.getWorkspace().getLockManager().unlock(path);
    }

    private static class JCRLock
    implements Lock {
        private boolean isDeep;
        private String token;

        public JCRLock(javax.jcr.lock.Lock lock) throws RepositoryException {
            this.isDeep = lock.isDeep();
            this.token = lock.getLockToken();
        }

        @Override
        public String getLockToken() {
            return this.token;
        }

        @Override
        public boolean isDeep() {
            return this.isDeep;
        }
    }
}

