/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.services.ServiceHelpers;
import org.fcrepo.kernel.services.functions.CacheLocalTransform;
import org.fcrepo.kernel.services.functions.GetBinaryKey;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.impl.ChainingCacheStoreEntry;
import org.fcrepo.kernel.utils.impl.LocalBinaryStoreEntry;
import org.infinispan.distexec.DistributedExecutorService;
import org.modeshape.jcr.GetBinaryStore;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.CompositeBinaryStore;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LowLevelStorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LowLevelStorageService.class);
    @Inject
    private Repository repo;
    private Echo echo = new Echo();
    private GetBinaryStore getBinaryStore = new GetBinaryStore();
    private GetBinaryKey getBinaryKey = new GetBinaryKey();

    public <T> Collection<T> transformLowLevelCacheEntries(Node resource, Function<LowLevelCacheEntry, T> transform) throws RepositoryException {
        return this.transformLowLevelCacheEntries(resource.getProperty("jcr:data"), transform);
    }

    public <T> Collection<T> transformLowLevelCacheEntries(Property jcrBinaryProperty, Function<LowLevelCacheEntry, T> transform) {
        return this.transformLowLevelCacheEntries(this.getBinaryKey.apply(jcrBinaryProperty), transform);
    }

    public <T> Collection<T> transformLowLevelCacheEntries(BinaryKey key, Function<LowLevelCacheEntry, T> transform) {
        BinaryStore store = this.getBinaryStore.apply(this.repo);
        return this.transformLowLevelCacheEntries(store, key, transform);
    }

    protected <T> Set<T> transformLowLevelCacheEntries(CompositeBinaryStore compositeStore, BinaryKey key, Function<LowLevelCacheEntry, T> transform) {
        ImmutableSet.Builder results = ImmutableSet.builder();
        Iterator it = compositeStore.getNamedStoreIterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            BinaryStore bs = (BinaryStore)entry.getValue();
            if (!bs.hasBinary(key)) continue;
            ExternalIdDecorator<T> decorator = new ExternalIdDecorator<T>((String)entry.getKey(), transform);
            Set<T> transformeds = this.transformLowLevelCacheEntries(bs, key, decorator);
            results.addAll(transformeds);
        }
        return results.build();
    }

    protected <T> Set<T> transformLowLevelCacheEntries(BinaryStore store, BinaryKey key, Function<LowLevelCacheEntry, T> transform) {
        if (store == null) {
            return Collections.emptySet();
        }
        if (store instanceof CompositeBinaryStore) {
            return this.transformLowLevelCacheEntries((CompositeBinaryStore)store, key, transform);
        }
        if (store instanceof InfinispanBinaryStore) {
            try {
                return this.getClusterResults((InfinispanBinaryStore)store, key, transform);
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted getting cluster results for binary key {} ", (Object)key, (Object)e);
                return Collections.emptySet();
            }
            catch (ExecutionException e) {
                LOGGER.error("Execution exception getting cluster results for binary key {}", (Object)key, (Object)e);
                return Collections.emptySet();
            }
        }
        return ImmutableSet.of((Object)transform.apply((Object)new LocalBinaryStoreEntry(store, key)));
    }

    public Set<LowLevelCacheEntry> getLowLevelCacheEntries(Node resource) throws RepositoryException {
        return this.getLowLevelCacheEntries(resource.getProperty("jcr:data"));
    }

    public Set<LowLevelCacheEntry> getLowLevelCacheEntries(Property jcrBinaryProperty) {
        return this.getLowLevelCacheEntries(this.getBinaryKey.apply(jcrBinaryProperty));
    }

    public Set<LowLevelCacheEntry> getLowLevelCacheEntries(BinaryKey key) {
        return this.getLowLevelCacheEntriesFromStore(this.getBinaryStore.apply(this.repo), key);
    }

    public Set<LowLevelCacheEntry> getLowLevelCacheEntriesFromStore(BinaryStore store, BinaryKey key) {
        return this.transformLowLevelCacheEntries(store, key, this.echo);
    }

    protected Set<LowLevelCacheEntry> getLowLevelCacheEntriesFromStore(CompositeBinaryStore compositeStore, BinaryKey key) {
        return this.transformLowLevelCacheEntries(compositeStore, key, this.echo);
    }

    protected Set<LowLevelCacheEntry> getLowLevelCacheEntriesFromStore(InfinispanBinaryStore ispnStore, BinaryKey key) {
        LOGGER.trace("Retrieving low-level cache entries for key {} from an InfinispanBinaryStore {}", (Object)key, (Object)ispnStore);
        try {
            return this.getClusterResults(ispnStore, key, this.echo);
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted getting cluster results for binary key {} ", (Object)key, (Object)e);
            return Collections.emptySet();
        }
        catch (ExecutionException e) {
            LOGGER.error("Execution exception getting cluster results for binary key {}", (Object)key, (Object)e);
            return Collections.emptySet();
        }
    }

    public <T> Set<T> getClusterResults(InfinispanBinaryStore cacheStore, BinaryKey key, Function<LowLevelCacheEntry, T> transform) throws InterruptedException, ExecutionException {
        DistributedExecutorService exec = ServiceHelpers.getClusterExecutor(cacheStore);
        List futures = exec.submitEverywhere(new CacheLocalTransform(key, new Unroll<T>(transform)));
        HashSet results = new HashSet(futures.size());
        while (!futures.isEmpty()) {
            Iterator futureIter = futures.iterator();
            while (futureIter.hasNext()) {
                Future future = (Future)futureIter.next();
                try {
                    Collection result = (Collection)future.get(100L, TimeUnit.MILLISECONDS);
                    futureIter.remove();
                    results.addAll(result);
                }
                catch (TimeoutException e) {
                    LOGGER.trace("Going to retry cluster transform after timeout", (Throwable)e);
                }
            }
        }
        return results;
    }

    public void setRepository(Repository repository) {
        this.repo = repository;
    }

    public void setGetBinaryStore(GetBinaryStore getBinaryStore) {
        this.getBinaryStore = getBinaryStore;
    }

    public void setGetBinaryKey(GetBinaryKey getBinaryKey) {
        this.getBinaryKey = getBinaryKey;
    }

    static class Unroll<T>
    implements Function<LowLevelCacheEntry, Collection<T>>,
    Serializable {
        private final Function<LowLevelCacheEntry, T> transform;
        private static final long serialVersionUID = -1L;

        Unroll(Function<LowLevelCacheEntry, T> transform) {
            this.transform = transform;
        }

        public Collection<T> apply(LowLevelCacheEntry input) {
            if (input instanceof ChainingCacheStoreEntry) {
                ImmutableSet.Builder entries = ImmutableSet.builder();
                Collection transformResult = Collections2.transform(((ChainingCacheStoreEntry)input).chainedEntries(), this.transform);
                entries.addAll((Iterable)transformResult);
                return entries.build();
            }
            return ImmutableSet.of((Object)this.transform.apply((Object)input));
        }
    }

    static class Echo
    implements Function<LowLevelCacheEntry, LowLevelCacheEntry>,
    Serializable {
        private static final long serialVersionUID = -1L;

        Echo() {
        }

        public LowLevelCacheEntry apply(LowLevelCacheEntry input) {
            return input;
        }
    }

    static class ExternalIdDecorator<T>
    implements Function<LowLevelCacheEntry, T>,
    Serializable {
        private static final long serialVersionUID = 7375231595038804409L;
        final String externalId;
        final Function<LowLevelCacheEntry, T> transform;

        ExternalIdDecorator(String externalId, Function<LowLevelCacheEntry, T> transform) {
            this.externalId = externalId;
            this.transform = transform;
        }

        public T apply(LowLevelCacheEntry input) {
            input.setExternalId(this.externalId);
            return (T)this.transform.apply((Object)input);
        }
    }
}

