/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.google.common.base.Function;
import java.net.URI;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.fcrepo.kernel.services.functions.CheckCacheEntryFixity;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedExecutorService;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.springframework.stereotype.Component;

@Component
public abstract class ServiceHelpers {
    public static Long getNodePropertySize(Node node) throws RepositoryException {
        Long size = 0L;
        PropertyIterator i = node.getProperties();
        while (i.hasNext()) {
            Property p = i.nextProperty();
            if (p.isMultiple()) {
                for (Value v : p.getValues()) {
                    size = size + v.getBinary().getSize();
                }
                continue;
            }
            size = size + p.getBinary().getSize();
        }
        return size;
    }

    public static Long getObjectSize(Node obj) throws RepositoryException {
        return ServiceHelpers.getNodePropertySize(obj) + ServiceHelpers.getObjectDSSize(obj);
    }

    private static Long getObjectDSSize(Node obj) throws RepositoryException {
        Long size = 0L;
        NodeIterator i = obj.getNodes();
        while (i.hasNext()) {
            Node node = i.nextNode();
            if (!node.isNodeType("nt:file")) continue;
            size = size + ServiceHelpers.getDatastreamSize(node);
        }
        return size;
    }

    public static Long getDatastreamSize(Node ds) throws RepositoryException {
        return ServiceHelpers.getNodePropertySize(ds) + ServiceHelpers.getContentSize(ds);
    }

    public static Long getContentSize(Node ds) throws RepositoryException {
        Node contentNode;
        long size = 0L;
        if (ds.hasNode("jcr:content") && (contentNode = ds.getNode("jcr:content")).hasProperty("jcr:data")) {
            size = ds.getNode("jcr:content").getProperty("jcr:data").getBinary().getSize();
        }
        return size;
    }

    public static DistributedExecutorService getClusterExecutor(InfinispanBinaryStore cacheStore) {
        return new DefaultExecutorService((Cache)cacheStore.getCaches().get(1));
    }

    public static Function<LowLevelCacheEntry, FixityResult> getCheckCacheFixityFunction(URI dsChecksum, long dsSize) {
        return new CheckCacheEntryFixity(dsChecksum, dsSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRepositoryCount(Repository repository) throws RepositoryException {
        Session session = repository.login();
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String querystring = "SELECT [jcr:path] FROM [fedora:object]";
            QueryResult queryResults = queryManager.createQuery("SELECT [jcr:path] FROM [fedora:object]", "JCR-SQL2").execute();
            long l = queryResults.getRows().getSize();
            return l;
        }
        finally {
            session.logout();
        }
    }

    public static long getRepositorySize(Repository repository) throws RepositoryException {
        Session session = repository.login();
        long sum = 0L;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String querystring = "SELECT [premis:hasSize] FROM [fedora:binary]";
        QueryResult queryResults = queryManager.createQuery("SELECT [premis:hasSize] FROM [fedora:binary]", "JCR-SQL2").execute();
        RowIterator rows = queryResults.getRows();
        while (rows.hasNext()) {
            Value value = rows.nextRow().getValue("premis:hasSize");
            sum += value.getLong();
        }
        session.logout();
        return sum;
    }
}

