/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.Transaction;
import org.fcrepo.kernel.exception.TransactionMissingException;
import org.fcrepo.kernel.services.AbstractService;
import org.fcrepo.kernel.services.TransactionService;
import org.fcrepo.kernel.services.TransactionServiceImpl;
import org.fcrepo.kernel.services.VersionService;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionServiceImpl
extends AbstractService
implements VersionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionService.class);
    protected static final String VERSIONABLE = "mix:versionable";
    protected static final String VERSION_POLICY = "fedoraconfig:versioningPolicy";
    protected static final String AUTO_VERSION = "auto-version";
    @Autowired
    private TransactionService txService;

    @Override
    public void nodeUpdated(Session session, String absPath) throws RepositoryException {
        this.nodeUpdated(session.getNode(absPath));
    }

    @Override
    public void nodeUpdated(Node n) throws RepositoryException {
        if (VersionServiceImpl.isVersioningEnabled(n) && VersionServiceImpl.isImplicitVersioningEnabled(n)) {
            this.queueOrCommitCheckpoint(n.getSession(), n.getPath());
        } else {
            LOGGER.trace("No implicit version checkpoint set for {}", (Object)n.getPath());
        }
    }

    @Override
    public void createVersion(Workspace workspace, Collection<String> paths) throws RepositoryException {
        for (String absPath : paths) {
            VersionServiceImpl.checkpoint(workspace, absPath);
        }
    }

    @Override
    public void revertToVersion(Workspace workspace, String absPath, String label) throws RepositoryException {
        Version v = this.getVersionForLabel(workspace, absPath, label);
        if (v == null) {
            throw new PathNotFoundException("Unknown version \"" + label + "\"!");
        }
        VersionManager versionManager = workspace.getVersionManager();
        versionManager.checkin(absPath);
        versionManager.restore(v, true);
        versionManager.checkout(absPath);
        this.nodeUpdated(workspace.getSession(), absPath);
    }

    @Override
    public void removeVersion(Workspace workspace, String absPath, String label) throws RepositoryException {
        String[] versionLabels;
        Version v = this.getVersionForLabel(workspace, absPath, label);
        if (v == null) {
            throw new PathNotFoundException("Unknown version \"" + label + "\"!");
        }
        if (workspace.getVersionManager().getBaseVersion(absPath).equals(v)) {
            throw new VersionException("Cannot remove current version");
        }
        VersionHistory history = v.getContainingHistory();
        for (String versionLabel : versionLabels = history.getVersionLabels(v)) {
            LOGGER.debug("Removing label: {}", (Object)versionLabel);
            history.removeVersionLabel(versionLabel);
        }
        history.removeVersion(v.getName());
    }

    private Version getVersionForLabel(Workspace workspace, String absPath, String label) throws RepositoryException {
        VersionHistory history = workspace.getVersionManager().getVersionHistory(absPath);
        try {
            return history.getVersionByLabel(label);
        }
        catch (VersionException ex) {
            VersionIterator versionIt = history.getAllVersions();
            while (versionIt.hasNext()) {
                Version v = versionIt.nextVersion();
                if (!v.getFrozenNode().getIdentifier().equals(label)) continue;
                return v;
            }
            return null;
        }
    }

    private static boolean isVersioningEnabled(Node n) throws RepositoryException {
        return n.isNodeType(VERSIONABLE);
    }

    private static boolean isImplicitVersioningEnabled(Node n) throws RepositoryException {
        if (!n.hasProperty(VERSION_POLICY)) {
            return false;
        }
        Property p = n.getProperty(VERSION_POLICY);
        return FedoraTypesUtils.propertyContains(p, AUTO_VERSION);
    }

    private void queueOrCommitCheckpoint(Session session, String absPath) throws RepositoryException {
        String txId = TransactionServiceImpl.getCurrentTransactionId(session);
        if (txId == null) {
            VersionServiceImpl.checkpoint(session.getWorkspace(), absPath);
        } else {
            this.queueCheckpoint(txId, absPath);
        }
    }

    private static void checkpoint(Workspace workspace, String absPath) throws RepositoryException {
        LOGGER.trace("Setting implicit version checkpoint set for {}", (Object)absPath);
        workspace.getVersionManager().checkpoint(absPath);
    }

    private void queueCheckpoint(String txId, String absPath) throws TransactionMissingException {
        Transaction tx = this.txService.getTransaction(txId);
        LOGGER.trace("Queuing implicit version checkpoint set for {}", (Object)absPath);
        tx.addPathToVersion(absPath);
    }

    @Override
    public void checkpoint(Node node) throws RepositoryException {
        Preconditions.checkNotNull((Object)node, (Object)"Cannot checkpoint null nodes");
        Session session = node.getSession();
        String absPath = node.getPath();
        if (node.isNodeType(VERSIONABLE)) {
            LOGGER.trace("Setting checkpoint for {}", (Object)absPath);
            String txId = TransactionServiceImpl.getCurrentTransactionId(session);
            if (txId != null) {
                Transaction tx = this.txService.getTransaction(txId);
                tx.addPathToVersion(absPath);
            } else {
                session.getWorkspace().getVersionManager().checkpoint(absPath);
            }
        } else {
            LOGGER.trace("No checkpoint set for unversionable {}", (Object)absPath);
        }
    }

    @Override
    public void setTxService(TransactionService txService) {
        this.txService = txService;
    }
}

