/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services.functions;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.io.Serializable;
import java.net.URI;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckCacheEntryFixity
implements Function<LowLevelCacheEntry, FixityResult>,
Serializable {
    private static final long serialVersionUID = 4701589005571818110L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LowLevelStorageService.class);
    private final URI dsChecksum;
    private final long dsSize;

    public CheckCacheEntryFixity(URI dsChecksum, long dsSize) {
        this.dsChecksum = dsChecksum;
        this.dsSize = dsSize;
    }

    public FixityResult apply(LowLevelCacheEntry input) {
        LOGGER.debug("Checking fixity for resource in cache store: {} ", (Object)input);
        try {
            return input.checkFixity(this.dsChecksum, this.dsSize);
        }
        catch (RepositoryException e) {
            LOGGER.error("Exception checking low-level fixity: {}", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public URI getChecksum() {
        return this.dsChecksum;
    }

    public long getSize() {
        return this.dsSize;
    }
}

