/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Repository;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.modeshape.jcr.GetBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetClusterConfiguration
implements Function<Repository, Map<String, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetClusterConfiguration.class);
    public static final String CLUSTER_NAME = "clusterName";
    public static final String CACHE_MODE = "clusterCacheMode";
    public static final String NODE_ADDRESS = "clusterNodeAddress";
    public static final String PHYSICAL_ADDRESS = "clusterPhysicalAddress";
    public static final String NODE_VIEW = "clusterNodeView";
    public static final String CLUSTER_SIZE = "clusterSize";
    public static final String CLUSTER_MEMBERS = "clusterMembers";
    public static final int UNKNOWN_NODE_VIEW = -1;
    private GetBinaryStore getBinaryStore = new GetBinaryStore();

    public Map<String, String> apply(Repository input) {
        Preconditions.checkNotNull((Object)input, (Object)"null cannot have a BinaryStore!");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        BinaryStore store = this.getBinaryStore.apply(input);
        if (!(store instanceof InfinispanBinaryStore)) {
            return result;
        }
        InfinispanBinaryStore ispnStore = (InfinispanBinaryStore)store;
        List caches = ispnStore.getCaches();
        DefaultCacheManager cm = (DefaultCacheManager)((Cache)caches.get(0)).getCacheManager();
        if (cm == null) {
            LOGGER.debug("Could not get cluster configuration information");
            return result;
        }
        int nodeView = cm.getTransport() != null ? cm.getTransport().getViewId() + 1 : -1;
        result.put(CLUSTER_NAME, cm.getClusterName());
        result.put(CACHE_MODE, cm.getCache().getCacheConfiguration().clustering().cacheMode().toString());
        result.put(NODE_ADDRESS, cm.getNodeAddress());
        result.put(PHYSICAL_ADDRESS, cm.getPhysicalAddresses());
        result.put(NODE_VIEW, nodeView == -1 ? "Unknown" : String.valueOf(nodeView));
        result.put(CLUSTER_SIZE, String.valueOf(cm.getClusterSize()));
        result.put(CLUSTER_MEMBERS, cm.getClusterMembers());
        return result;
    }
}

