/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.base.Throwables;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.NodePropertiesTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPropertyStatementListener
extends StatementListener {
    private final JcrRdfTools jcrRdfTools;
    private NodePropertiesTools propertiesTools = new NodePropertiesTools();
    private Model problems;
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrPropertyStatementListener.class);
    private final IdentifierTranslator subjects;
    private final Session session;

    public static JcrPropertyStatementListener getListener(IdentifierTranslator subjects, Session session, Model problemModel) {
        return new JcrPropertyStatementListener(subjects, session, problemModel);
    }

    private JcrPropertyStatementListener(IdentifierTranslator subjects, Session session, Model problems) {
        this.session = session;
        this.subjects = subjects;
        this.problems = problems;
        this.jcrRdfTools = JcrRdfTools.withContext(subjects, session);
    }

    public void addedStatement(Statement s) {
        LOGGER.debug(">> added statement {}", (Object)s);
        try {
            Resource subject = s.getSubject();
            if (!this.subjects.isFedoraGraphSubject(subject)) {
                return;
            }
            Node subjectNode = this.session.getNode(this.subjects.getPathFromSubject(subject));
            if (s.getPredicate().equals(RDF.type) && s.getObject().isResource()) {
                Resource mixinResource = s.getObject().asResource();
                if (mixinResource.getNameSpace().equals("http://www.w3.org/ns/ldp#")) {
                    return;
                }
                try {
                    String namespacePrefix = this.session.getNamespacePrefix(mixinResource.getNameSpace());
                    String mixinName = namespacePrefix + ":" + mixinResource.getLocalName();
                    if (FedoraTypesUtils.getNodeTypeManager(subjectNode).hasNodeType(mixinName)) {
                        if (subjectNode.canAddMixin(mixinName)) {
                            subjectNode.addMixin(mixinName);
                        } else {
                            this.problems.add(subject, RdfLexicon.COULD_NOT_STORE_PROPERTY, s.getPredicate().getURI());
                        }
                        return;
                    }
                }
                catch (NamespaceException e) {
                    LOGGER.trace("Unable to resolve registered namespace for resource {}: {}", (Object)mixinResource, (Object)e);
                }
            }
            String propertyName = this.jcrRdfTools.getPropertyNameFromPredicate(subjectNode, s.getPredicate(), (Map<String, String>)s.getModel().getNsPrefixMap());
            if (this.validateModificationsForPropertyName(subject, subjectNode, (Resource)s.getPredicate())) {
                Value v = this.jcrRdfTools.createValue(subjectNode, s.getObject(), this.propertiesTools.getPropertyType(subjectNode, propertyName));
                this.propertiesTools.appendOrReplaceNodeProperty(this.subjects, subjectNode, propertyName, v);
            }
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void removedStatement(Statement s) {
        LOGGER.trace(">> removed statement {}", (Object)s);
        try {
            String propertyName;
            Node subjectNode;
            Resource subject;
            block9: {
                subject = s.getSubject();
                if (!this.subjects.isFedoraGraphSubject(subject)) {
                    return;
                }
                subjectNode = this.session.getNode(this.subjects.getPathFromSubject(subject));
                if (s.getPredicate().equals(RDF.type) && s.getObject().isResource()) {
                    Resource mixinResource = s.getObject().asResource();
                    try {
                        String namespacePrefix = this.session.getNamespacePrefix(mixinResource.getNameSpace());
                        String mixinName = namespacePrefix + ":" + mixinResource.getLocalName();
                        if (!FedoraTypesUtils.getNodeTypeManager(subjectNode).hasNodeType(mixinName)) break block9;
                        try {
                            subjectNode.removeMixin(mixinName);
                        }
                        catch (RepositoryException e) {
                            LOGGER.info("problem with removing <{}> <{}> <{}>: {}", new Object[]{subject.getURI(), RdfLexicon.COULD_NOT_STORE_PROPERTY, s.getPredicate().getURI(), e});
                            this.problems.add(subject, RdfLexicon.COULD_NOT_STORE_PROPERTY, s.getPredicate().getURI());
                        }
                        return;
                    }
                    catch (NamespaceException e) {
                        LOGGER.trace("Unable to resolve registered namespace for resource {}: {}", (Object)mixinResource, (Object)e);
                    }
                }
            }
            if (subjectNode.hasProperty(propertyName = this.jcrRdfTools.getPropertyNameFromPredicate(subjectNode, s.getPredicate())) && this.validateModificationsForPropertyName(subject, subjectNode, (Resource)s.getPredicate())) {
                Value v = this.jcrRdfTools.createValue(subjectNode, s.getObject(), this.propertiesTools.getPropertyType(subjectNode, propertyName));
                this.propertiesTools.removeNodeProperty(this.subjects, subjectNode, propertyName, v);
            }
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private boolean validateModificationsForPropertyName(Resource subject, Node subjectNode, Resource predicate) {
        if (this.jcrRdfTools.isInternalProperty(subjectNode, predicate)) {
            LOGGER.debug("problem with <{}> <{}> <{}>", new Object[]{subject.getURI(), RdfLexicon.COULD_NOT_STORE_PROPERTY, predicate.getURI()});
            this.problems.add(subject, RdfLexicon.COULD_NOT_STORE_PROPERTY, predicate.getURI());
            return false;
        }
        return true;
    }

    public Model getProblems() {
        return this.problems;
    }
}

