/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.collect.Iterables;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.ArrayList;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.exception.NoSuchPropertyDefinitionException;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePropertiesTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodePropertiesTools.class);
    public static final String REFERENCE_PROPERTY_SUFFIX = "_ref";

    public void appendOrReplaceNodeProperty(IdentifierTranslator subjects, Node node, String propertyName, Value newValue) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            Property property = node.getProperty(propertyName);
            if (property.isMultiple()) {
                LOGGER.debug("Appending value {} to {} property {}", new Object[]{newValue, PropertyType.nameFromValue((int)property.getType()), propertyName});
                ArrayList<Value> newValues = new ArrayList<Value>();
                Collections.addAll(newValues, node.getProperty(propertyName).getValues());
                if (!newValues.contains(newValue)) {
                    newValues.add(newValue);
                    property.setValue((Value[])Iterables.toArray(newValues, Value.class));
                }
                this.addReferencePlaceholders(subjects, node, property, newValue);
            } else {
                LOGGER.debug("Overwriting {} property {} with new value {}", new Object[]{PropertyType.nameFromValue((int)property.getType()), propertyName, newValue});
                property.setValue(newValue);
                this.addReferencePlaceholders(subjects, node, property, newValue);
            }
        } else {
            boolean isMultiple = true;
            try {
                isMultiple = NodePropertiesTools.isMultivaluedProperty(node, propertyName);
            }
            catch (NoSuchPropertyDefinitionException e) {
                // empty catch block
            }
            if (isMultiple) {
                LOGGER.debug("Creating new multivalued {} property {} with initial value [{}]", new Object[]{PropertyType.nameFromValue((int)newValue.getType()), propertyName, newValue});
                Property property = node.setProperty(propertyName, new Value[]{newValue}, newValue.getType());
                this.addReferencePlaceholders(subjects, node, property, newValue);
            } else {
                LOGGER.debug("Creating new single-valued {} property {} with initial value {}", new Object[]{PropertyType.nameFromValue((int)newValue.getType()), propertyName, newValue});
                Property property = node.setProperty(propertyName, newValue, newValue.getType());
                this.addReferencePlaceholders(subjects, node, property, newValue);
            }
        }
    }

    private void addReferencePlaceholders(IdentifierTranslator subjects, Node node, Property property, Value newValue) throws RepositoryException {
        Resource resource;
        if (property.getType() == 11 && subjects.isFedoraGraphSubject(resource = ResourceFactory.createResource((String)newValue.getString()))) {
            Node refNode = node.getSession().getNode(subjects.getPathFromSubject(resource));
            String referencePropertyName = NodePropertiesTools.getReferencePropertyName(property);
            if (!property.isMultiple() && node.hasProperty(referencePropertyName)) {
                node.setProperty(referencePropertyName, (Value[])null);
            }
            Value v = node.getSession().getValueFactory().createValue(refNode, true);
            this.appendOrReplaceNodeProperty(subjects, node, referencePropertyName, v);
        }
    }

    private void removeReferencePlaceholders(IdentifierTranslator subjects, Node node, Property property, Value newValue) throws RepositoryException {
        Resource resource;
        if (property.getType() == 11 && subjects.isFedoraGraphSubject(resource = ResourceFactory.createResource((String)newValue.getString()))) {
            String referencePropertyName = NodePropertiesTools.getReferencePropertyName(property);
            if (!property.isMultiple() && node.hasProperty(referencePropertyName)) {
                node.setProperty(referencePropertyName, (Value[])null);
            } else {
                Node refNode = node.getSession().getNode(subjects.getPathFromSubject(resource));
                Value v = node.getSession().getValueFactory().createValue(refNode, true);
                this.removeNodeProperty(subjects, node, referencePropertyName, v);
            }
        }
    }

    public void removeNodeProperty(IdentifierTranslator subjects, Node node, String propertyName, Value valueToRemove) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            Property property = node.getProperty(propertyName);
            if (FedoraTypesUtils.isMultipleValuedProperty.apply((Object)property)) {
                ArrayList<Value> newValues = new ArrayList<Value>();
                boolean remove = false;
                for (Value v : node.getProperty(propertyName).getValues()) {
                    if (v.equals(valueToRemove)) {
                        remove = true;
                        continue;
                    }
                    newValues.add(v);
                }
                if (remove) {
                    if (newValues.isEmpty()) {
                        LOGGER.debug("Removing property {}", (Object)propertyName);
                        property.setValue((Value[])null);
                    } else {
                        LOGGER.debug("Removing value {} from property {}", (Object)valueToRemove, (Object)propertyName);
                        property.setValue((Value[])Iterables.toArray(newValues, Value.class));
                    }
                    this.removeReferencePlaceholders(subjects, node, property, valueToRemove);
                }
            } else if (property.getValue().equals(valueToRemove)) {
                LOGGER.debug("Removing value from property {}", (Object)propertyName);
                property.setValue((Value)null);
                if (property.getType() == 11 && node.hasProperty(NodePropertiesTools.getReferencePropertyName(propertyName))) {
                    this.removeReferencePlaceholders(subjects, node, property, valueToRemove);
                }
            }
        }
    }

    public static String getReferencePropertyName(String propertyName) {
        return propertyName + REFERENCE_PROPERTY_SUFFIX;
    }

    private static String getReferencePropertyName(Property property) throws RepositoryException {
        return NodePropertiesTools.getReferencePropertyName(property.getName());
    }

    public int getPropertyType(Node node, String propertyName) throws RepositoryException {
        LOGGER.debug("Getting type of property: {} from node: {}", (Object)propertyName, (Object)node);
        PropertyDefinition def = FedoraTypesUtils.getDefinitionForPropertyName(node, propertyName);
        if (def == null) {
            return 0;
        }
        return def.getRequiredType();
    }

    public static boolean isMultivaluedProperty(Node node, String propertyName) throws RepositoryException {
        PropertyDefinition def = FedoraTypesUtils.getDefinitionForPropertyName(node, propertyName);
        if (def == null) {
            throw new NoSuchPropertyDefinitionException();
        }
        return def.isMultiple();
    }
}

