/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.iterators;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.kernel.exception.MalformedRdfException;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.kernel.utils.NodePropertiesTools;
import org.fcrepo.kernel.utils.iterators.PersistingRdfStreamConsumer;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfAdder
extends PersistingRdfStreamConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfAdder.class);
    private final NodePropertiesTools propertiesTools = new NodePropertiesTools();

    public RdfAdder(IdentifierTranslator graphSubjects, Session session, RdfStream stream) {
        super(graphSubjects, session, stream);
    }

    @Override
    protected void operateOnMixin(Resource mixinResource, Node subjectNode) throws RepositoryException {
        String mixinName = this.jcrMixinNameFromRdfResource(mixinResource);
        if (this.session().getWorkspace().getNodeTypeManager().hasNodeType(mixinName)) {
            if (!subjectNode.canAddMixin(mixinName)) {
                throw new MalformedRdfException("Could not persist triple containing type assertion:" + mixinResource.toString() + " because no such mixin/type can be added to this node: " + subjectNode.getPath() + "!");
            }
        } else {
            throw new MalformedRdfException("Could not persist triple containing type assertion:" + mixinResource.toString() + " because no such mixin/type can be found in the repository!");
        }
        LOGGER.debug("Adding mixin: {} to node: {}.", (Object)mixinName, (Object)subjectNode.getPath());
        subjectNode.addMixin(mixinName);
    }

    @Override
    protected void operateOnProperty(Statement t, Node n) throws RepositoryException {
        LOGGER.debug("Adding property from triple: {} to node: {}.", (Object)t, (Object)n.getPath());
        String propertyName = this.getPropertyNameFromPredicate(n, t.getPredicate());
        Value v = this.createValue(n, t.getObject(), this.propertiesTools.getPropertyType(n, propertyName));
        this.propertiesTools.appendOrReplaceNodeProperty(this.idTranslator(), n, propertyName, v);
    }
}

