/**
 * Copyright 2014 DuraSpace, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.fcrepo.kernel.rdf;

import static com.hp.hpl.jena.sparql.util.Symbol.create;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.util.Symbol;


/**
 * @author barmintor
 * @since 2013
 */
public interface GraphProperties {

    Symbol URI_SYMBOL = create("uri");

    Symbol INLINED_RESOURCES_MODEL = create("inlined-resources-model");

    String PROBLEMS_MODEL_NAME = "problems";

    /**
     * Return the name of the model this property factory will insert
     * its properties into.
     * @return name of the model
     */
    String getPropertyModelName();

    /**
     * Return an offset list of the properties generated by this factory
     * for the given object and subject factory.
     * @param node
     * @param subjects
     * @param offset
     * @param limit
     * @return Dataset
     * @throws RepositoryException
     */
    Dataset getProperties(final Node node, final IdentifierTranslator subjects,
            final int offset, final int limit) throws RepositoryException;

    /**
     * Return a list of all properties generated by this factory
     * for the given object and subject factory.
     * @param node
     * @param subjects
     * @return Dataset of all properties generated by this factory
     * @throws RepositoryException
     */
    Dataset getProperties(final Node node, final IdentifierTranslator subjects)
        throws RepositoryException;
}
