/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Set;

public final class RdfLexicon {
    public static final String REPOSITORY_NAMESPACE = "http://fedora.info/definitions/v4/repository#";
    public static final String JCR_NAMESPACE = "http://www.jcp.org/jcr/1.0";
    public static final String RESTAPI_NAMESPACE = "http://fedora.info/definitions/v4/rest-api#";
    public static final String FEDORA_CONFIG_NAMESPACE = "http://fedora.info/definitions/v4/config#";
    public static final String PREMIS_NAMESPACE = "http://www.loc.gov/premis/rdf/v1#";
    public static final String LDP_NAMESPACE = "http://www.w3.org/ns/ldp#";
    public static final String SPARQL_SD_NAMESPACE = "http://www.w3.org/ns/sparql-service-description#";
    public static final Set<String> managedNamespaces = ImmutableSet.of((Object)"http://fedora.info/definitions/v4/rest-api#", (Object)"http://fedora.info/definitions/v4/repository#", (Object)"http://www.jcp.org/jcr/1.0", (Object)"http://www.w3.org/ns/ldp#");
    public static final Predicate<String> isManagedNamespace = Predicates.in(managedNamespaces);
    public static final String RELATIONS_NAMESPACE = "http://fedora.info/definitions/v4/rels-ext#";
    public static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String INDEXING_NAMESPACE = "http://fedora.info/definitions/v4/indexing#";
    public static final String DC_NAMESPACE = "http://purl.org/dc/elements/1.1/";
    public static final String MIX_NAMESPACE = "http://www.jcp.org/jcr/mix/1.0";
    public static final String JCR_NT_NAMESPACE = "http://www.jcp.org/jcr/nt/1.0";
    public static final Property HAS_MEMBER_OF_RESULT = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasMember");
    public static final Property HAS_PARENT = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasParent");
    public static final Property HAS_CHILD = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasChild");
    public static final Property HAS_CHILD_COUNT = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#numberOfChildren");
    public static final Set<Property> membershipProperties = ImmutableSet.of((Object)HAS_MEMBER_OF_RESULT, (Object)HAS_PARENT, (Object)HAS_CHILD, (Object)HAS_CHILD_COUNT);
    public static final Resource FIXITY_TYPE = ResourceFactory.createResource((String)"http://www.loc.gov/premis/rdf/v1#Fixity");
    public static final Property HAS_MESSAGE_DIGEST = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasMessageDigest");
    public static final Property HAS_SIZE = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasSize");
    public static final Property HAS_FIXITY_RESULT = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasFixity");
    public static final Property HAS_FIXITY_STATE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#status");
    public static final Property HAS_FIXITY_CHECK_COUNT = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#numFixityChecks");
    public static final Property HAS_FIXITY_ERROR_COUNT = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#numFixityErrors");
    public static final Property HAS_FIXITY_REPAIRED_COUNT = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#numFixityRepaired");
    public static final Set<Property> fixityProperties = ImmutableSet.of((Object)HAS_FIXITY_RESULT, (Object)HAS_MESSAGE_DIGEST, (Object)HAS_SIZE, (Object)HAS_FIXITY_STATE, (Object)HAS_FIXITY_CHECK_COUNT, (Object)HAS_FIXITY_ERROR_COUNT, (Object[])new Property[]{HAS_FIXITY_REPAIRED_COUNT});
    public static final Property SEARCH_PAGE = ResourceFactory.createProperty((String)"http://sindice.com/vocab/search#Page");
    public static final Property SEARCH_HAS_TOTAL_RESULTS = ResourceFactory.createProperty((String)"http://sindice.com/vocab/search#totalResults");
    public static final Property SEARCH_ITEMS_PER_PAGE = ResourceFactory.createProperty((String)"http://sindice.com/vocab/search#itemsPerPage");
    public static final Property SEARCH_OFFSET = ResourceFactory.createProperty((String)"http://sindice.com/vocab/search#startIndex");
    public static final Property SEARCH_TERMS = ResourceFactory.createProperty((String)"http://sindice.com/vocab/search#searchTerms");
    public static final Property SEARCH_HAS_MORE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/rest-api#hasMoreResults");
    public static final Property WRITABLE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/rest-api#writable");
    public static final Set<Property> searchProperties = ImmutableSet.of((Object)SEARCH_PAGE, (Object)SEARCH_HAS_TOTAL_RESULTS, (Object)SEARCH_ITEMS_PER_PAGE, (Object)SEARCH_OFFSET, (Object)SEARCH_OFFSET, (Object)SEARCH_TERMS, (Object[])new Property[]{SEARCH_HAS_MORE});
    public static final Property LOCKS = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#locks");
    public static final Property HAS_LOCK = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasLock");
    public static final Property HAS_LOCK_TOKEN = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasLockToken");
    public static final Property IS_DEEP = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#isDeep");
    public static final Property PAGE = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#Page");
    public static final Property PAGE_OF = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#pageOf");
    public static final Property FIRST_PAGE = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#firstPage");
    public static final Property NEXT_PAGE = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#nextPage");
    public static final Resource CONTAINER = ResourceFactory.createResource((String)"http://www.w3.org/ns/ldp#Container");
    public static final Resource DIRECT_CONTAINER = ResourceFactory.createResource((String)"http://www.w3.org/ns/ldp#DirectContainer");
    public static final Property MEMBERSHIP_RESOURCE = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#membershipResource");
    public static final Property HAS_MEMBER_RELATION = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#hasMemberRelation");
    public static final Property CONTAINS = ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#contains");
    public static final Set<Property> ldpProperties = ImmutableSet.of((Object)PAGE, (Object)PAGE_OF, (Object)FIRST_PAGE, (Object)NEXT_PAGE, (Object)MEMBERSHIP_RESOURCE, (Object)HAS_MEMBER_RELATION, (Object[])new Property[]{CONTAINS});
    public static final Set<Resource> ldpResources = ImmutableSet.of((Object)CONTAINER, (Object)DIRECT_CONTAINER);
    public static final Property HAS_OBJECT_COUNT = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#objectCount");
    public static final Property HAS_OBJECT_SIZE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#objectSize");
    public static final Property HAS_TRANSACTION_SERVICE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/rest-api#hasTransactionProvider");
    public static final Property HAS_NAMESPACE_SERVICE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/rest-api#hasNamespaces");
    public static final Property HAS_WORKSPACE_SERVICE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/rest-api#hasWorkspaces");
    public static final Property HAS_ACCESS_ROLES_SERVICE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/rest-api#hasAccessRoles");
    public static final Property HAS_SEARCH_SERVICE = ResourceFactory.createProperty((String)"http://www.whatwg.org/specs/web-apps/current-work/#link-type-search");
    public static final Property HAS_SITEMAP = ResourceFactory.createProperty((String)"http://microformats.org/wiki/rel-sitemap");
    public static final Set<Property> repositoryProperties = ImmutableSet.of((Object)HAS_OBJECT_COUNT, (Object)HAS_OBJECT_SIZE, (Object)HAS_TRANSACTION_SERVICE, (Object)HAS_NAMESPACE_SERVICE, (Object)HAS_WORKSPACE_SERVICE, (Object)HAS_SEARCH_SERVICE, (Object[])new Property[]{HAS_SITEMAP});
    public static final Property HAS_NAMESPACE_PREFIX = ResourceFactory.createProperty((String)"http://purl.org/vocab/vann/preferredNamespacePrefix");
    public static final Property HAS_NAMESPACE_URI = ResourceFactory.createProperty((String)"http://purl.org/vocab/vann/preferredNamespaceUri");
    public static final Property VOAF_VOCABULARY = ResourceFactory.createProperty((String)"http://purl.org/vocommons/voaf#Vocabulary");
    public static final Set<Property> namespaceProperties = ImmutableSet.of((Object)HAS_NAMESPACE_PREFIX, (Object)HAS_NAMESPACE_URI, (Object)VOAF_VOCABULARY);
    public static final Property HAS_SERIALIZATION = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/rest-api#exportsAs");
    public static final Property HAS_VERSION_HISTORY = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/rest-api#hasVersions");
    public static final Property HAS_FIXITY_SERVICE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/rest-api#hasFixityService");
    public static final Property HAS_FEED = ResourceFactory.createProperty((String)"http://www.whatwg.org/specs/web-apps/current-work/#", (String)"feed0");
    public static final Property HAS_SUBSCRIPTION_SERVICE = ResourceFactory.createProperty((String)"http://microformats.org/wiki/rel-subscription");
    public static final Property NOT_IMPLEMENTED = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#notImplemented");
    public static final Property HAS_SPARQL_ENDPOINT = ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#endpoint");
    public static final Set<Property> otherServiceProperties = ImmutableSet.of((Object)HAS_SERIALIZATION, (Object)HAS_VERSION_HISTORY, (Object)HAS_FIXITY_SERVICE, (Object)HAS_FEED, (Object)HAS_SUBSCRIPTION_SERVICE, (Object)NOT_IMPLEMENTED, (Object[])new Property[0]);
    public static final Property HAS_CONTENT = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasContent");
    public static final Property IS_CONTENT_OF = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#isContentOf");
    public static final Resource CONTENT_LOCATION_TYPE = ResourceFactory.createResource((String)"http://www.loc.gov/premis/rdf/v1#ContentLocation");
    public static final Property HAS_CONTENT_LOCATION = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasContentLocation");
    public static final Property HAS_CONTENT_LOCATION_VALUE = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasContentLocationValue");
    public static final Property HAS_MIME_TYPE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#mimeType");
    public static final Property HAS_ORIGINAL_NAME = ResourceFactory.createProperty((String)"http://www.loc.gov/premis/rdf/v1#hasOriginalName");
    public static final Set<Property> contentProperties = ImmutableSet.of((Object)HAS_CONTENT, (Object)IS_CONTENT_OF, (Object)HAS_CONTENT_LOCATION, (Object)HAS_CONTENT_LOCATION_VALUE, (Object)HAS_MIME_TYPE, (Object)HAS_ORIGINAL_NAME, (Object[])new Property[]{HAS_SIZE});
    public static final Property HAS_VERSION = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasVersion");
    public static final Property HAS_VERSION_LABEL = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasVersionLabel");
    public static final Property VERSIONING_POLICY = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/config#versioningPolicy");
    public static final Set<Property> versioningProperties = ImmutableSet.of((Object)HAS_VERSION, (Object)HAS_VERSION_LABEL);
    public static final Property COULD_NOT_STORE_PROPERTY = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#couldNotStoreProperty");
    public static final Property INBOUND_REFERENCES = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#InboundReferences");
    public static final Property HAS_PRIMARY_IDENTIFIER = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#uuid");
    public static final Property HAS_PRIMARY_TYPE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#primaryType");
    public static final Property HAS_NODE_TYPE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasNodeType");
    public static final Property HAS_MIXIN_TYPE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#mixinTypes");
    public static final Property CREATED_DATE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#created");
    public static final Property CREATED_BY = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#createdBy");
    public static final Property LAST_MODIFIED_DATE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#lastModified");
    public static final Property LAST_MODIFIED_BY = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#lastModifiedBy");
    public static final Set<Property> jcrProperties = ImmutableSet.of((Object)HAS_PRIMARY_IDENTIFIER, (Object)HAS_PRIMARY_TYPE, (Object)HAS_NODE_TYPE, (Object)HAS_MIXIN_TYPE, (Object)CREATED_DATE, (Object)CREATED_BY, (Object[])new Property[]{LAST_MODIFIED_DATE, LAST_MODIFIED_BY});
    public static final Property RDFS_LABEL = ResourceFactory.createProperty((String)"http://www.w3.org/2000/01/rdf-schema#label");
    public static final Property DC_TITLE = ResourceFactory.createProperty((String)"http://purl.org/dc/elements/1.1/title");
    public static final Resource WORKSPACE_TYPE = ResourceFactory.createResource((String)"http://www.jcp.org/jcr/1.0#Workspace");
    public static final Property HAS_WORKSPACE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasWorkspace");
    public static final Property HAS_DEFAULT_WORKSPACE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasDefaultWorkspace");
    public static final Set<Property> managedProperties;
    private static Predicate<Property> hasJcrNamespace;
    private static Predicate<Property> hasFedoraNamespace;
    public static final Predicate<Property> isManagedPredicate;
    public static Predicate<String> isManagedPredicateURI;

    private RdfLexicon() {
    }

    static {
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.addAll(membershipProperties).addAll(fixityProperties).addAll(searchProperties).addAll(ldpProperties).addAll(repositoryProperties).addAll(namespaceProperties).addAll(otherServiceProperties).addAll(contentProperties).addAll(versioningProperties).addAll(jcrProperties);
        managedProperties = b.build();
        hasJcrNamespace = new Predicate<Property>(){

            public boolean apply(Property p) {
                return !p.isAnon() && p.getNameSpace().equals(RdfLexicon.JCR_NAMESPACE);
            }
        };
        hasFedoraNamespace = new Predicate<Property>(){

            public boolean apply(Property p) {
                return !p.isAnon() && p.getNameSpace().startsWith(RdfLexicon.REPOSITORY_NAMESPACE);
            }
        };
        isManagedPredicate = Predicates.or((Predicate[])new Predicate[]{Predicates.in(managedProperties), hasJcrNamespace, hasFedoraNamespace});
        isManagedPredicateURI = new Predicate<String>(){

            public boolean apply(String uri) {
                return isManagedPredicate.apply((Object)ResourceFactory.createProperty((String)uri));
            }
        };
    }
}

