/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf;

public class HierarchyRdfContextOptions {
    public static final HierarchyRdfContextOptions DEFAULT = HierarchyRdfContextOptions.defaultOptions();
    public static final int DEFAULT_LIMIT = -1;
    public static final int DEFAULT_OFFSET = -1;
    public static final boolean DEFAULT_MEMBERSHIP = true;
    public static final boolean DEFAULT_CONTAINMENT = true;
    private final int limit;
    private final int offset;
    private final boolean membership;
    private final boolean containment;

    public HierarchyRdfContextOptions() {
        this(-1, -1);
    }

    public HierarchyRdfContextOptions(int limit, int offset) {
        this(limit, offset, true, true);
    }

    public HierarchyRdfContextOptions(int limit, int offset, boolean membership, boolean containment) {
        this.limit = limit;
        this.offset = offset;
        this.membership = membership;
        this.containment = containment;
    }

    public boolean membershipEnabled() {
        return this.membership || this.containment;
    }

    public boolean containmentEnabled() {
        return this.containment;
    }

    public boolean hasOffset() {
        return this.getOffset() >= 0;
    }

    public boolean hasLimit() {
        return this.getLimit() >= 0;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    private static HierarchyRdfContextOptions defaultOptions() {
        return new HierarchyRdfContextOptions();
    }
}

