/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.iterators;

import com.google.common.collect.AbstractIterator;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import java.util.Iterator;

public class GraphDifferencingIterator
extends AbstractIterator<Triple> {
    private Graph notCommon;
    private Graph common;
    private Iterator<Triple> source;

    public GraphDifferencingIterator(Model replacement, Iterator<Triple> original) {
        this(replacement.getGraph(), original);
    }

    public GraphDifferencingIterator(Graph replacement, Iterator<Triple> original) {
        this.notCommon = replacement;
        this.common = GraphFactory.createDefaultGraph();
        this.source = original;
    }

    protected Triple computeNext() {
        if (this.source.hasNext()) {
            Triple next = this.source.next();
            while (this.common.contains(next) || this.notCommon.contains(next)) {
                if (this.notCommon.contains(next)) {
                    this.notCommon.remove(next.getSubject(), next.getPredicate(), next.getObject());
                    this.common.add(next);
                }
                if (!this.source.hasNext()) {
                    return (Triple)this.endOfData();
                }
                next = this.source.next();
            }
            return next;
        }
        return (Triple)this.endOfData();
    }

    public Iterator<Triple> common() {
        return this.source.hasNext() ? null : this.common.find(Node.ANY, Node.ANY, Node.ANY);
    }

    public Iterator<Triple> notCommon() {
        return this.source.hasNext() ? null : this.notCommon.find(Node.ANY, Node.ANY, Node.ANY);
    }
}

