/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.utils.EventType;

public class FedoraEvent {
    private Event e;
    private Set<Integer> eventTypes = new HashSet<Integer>();
    private Set<String> eventProperties = new HashSet<String>();

    public FedoraEvent(Event e) {
        Preconditions.checkArgument((e != null ? 1 : 0) != 0, (Object)"null cannot support a FedoraEvent!");
        this.e = e;
    }

    public FedoraEvent(FedoraEvent e) {
        Preconditions.checkArgument((e != null ? 1 : 0) != 0, (Object)"null cannot support a FedoraEvent!");
        this.e = e.e;
    }

    public Set<Integer> getTypes() {
        return this.eventTypes != null ? Sets.union(Collections.singleton(this.e.getType()), this.eventTypes) : Collections.singleton(this.e.getType());
    }

    public FedoraEvent addType(Integer type) {
        this.eventTypes.add(type);
        return this;
    }

    public Set<String> getProperties() {
        return this.eventProperties;
    }

    public FedoraEvent addProperty(String property) {
        this.eventProperties.add(property);
        return this;
    }

    public String getPath() throws RepositoryException {
        if (this.e.getType() == 4 || this.e.getType() == 16 || this.e.getType() == 8) {
            return this.e.getPath().substring(0, this.e.getPath().lastIndexOf("/"));
        }
        return this.e.getPath();
    }

    public String getUserID() {
        return this.e.getUserID();
    }

    public String getIdentifier() throws RepositoryException {
        return this.e.getIdentifier();
    }

    public Map<Object, Object> getInfo() throws RepositoryException {
        return new HashMap<Object, Object>(this.e.getInfo());
    }

    public String getUserData() throws RepositoryException {
        return this.e.getUserData();
    }

    public long getDate() throws RepositoryException {
        return this.e.getDate();
    }

    public String toString() {
        try {
            return MoreObjects.toStringHelper((Object)this).add("Event types:", (Object)Joiner.on((char)',').join(Iterables.transform(this.getTypes(), (Function)new Function<Integer, String>(){

                public String apply(Integer type) {
                    return EventType.valueOf(type).getName();
                }
            }))).add("Event properties:", (Object)Joiner.on((char)',').join(this.eventProperties)).add("Path:", (Object)this.getPath()).add("Date: ", this.getDate()).add("Info:", this.getInfo()).toString();
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

