/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.exception.FedoraInvalidNamespaceException;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;

public abstract class NamespaceTools {
    public static Function<Node, org.modeshape.jcr.api.NamespaceRegistry> getNamespaceRegistry = new Function<Node, org.modeshape.jcr.api.NamespaceRegistry>(){

        public org.modeshape.jcr.api.NamespaceRegistry apply(Node n) {
            try {
                Preconditions.checkNotNull((Object)n, (Object)"null has no Namespace Registry associated with it!");
                return (org.modeshape.jcr.api.NamespaceRegistry)n.getSession().getWorkspace().getNamespaceRegistry();
            }
            catch (RepositoryException e) {
                throw new IllegalStateException(e);
            }
        }
    };

    public static NamespaceRegistry getNamespaceRegistry(Session session) {
        try {
            NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
            Preconditions.checkNotNull((Object)namespaceRegistry, (Object)"Couldn't find namespace registry in repository!");
            return namespaceRegistry;
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException(e);
        }
    }

    public static void validatePath(Session session, String path) {
        String[] pathSegments;
        NamespaceRegistry namespaceRegistry = NamespaceTools.getNamespaceRegistry(session);
        String relPath = path.replaceAll("^/+", "").replaceAll("/+$", "");
        for (String segment : pathSegments = relPath.split("/")) {
            if (segment.length() <= 0 || !segment.contains(":") || segment.substring(0, segment.indexOf(":")).equals("fedora")) continue;
            String prefix = segment.substring(0, segment.indexOf(":"));
            if (prefix.length() == 0) {
                throw new FedoraInvalidNamespaceException(String.format("Unable to identify namespace for (%s)", segment));
            }
            try {
                namespaceRegistry.getURI(prefix);
            }
            catch (NamespaceException e) {
                throw new FedoraInvalidNamespaceException(String.format("The namespace prefix (%s) has not been registered", prefix), e);
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException(e);
            }
        }
    }
}

