/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.iterators;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.jcr.Session;

public class RdfStream
extends ForwardingIterator<Triple> {
    private Map<String, String> namespaces = new HashMap<String, String>();
    protected Iterator<Triple> triples;
    protected Session context;
    protected Node topic;
    private static final Triple[] NONE = new Triple[0];
    private static Function<Statement, Triple> statement2triple = new Function<Statement, Triple>(){

        public Triple apply(Statement s) {
            return s.asTriple();
        }
    };

    public <Tr extends Triple, T extends Iterator<Tr>> RdfStream(T triples) {
        this.triples = Iterators.transform(triples, RdfStream.cast());
    }

    public <Tr extends Triple, T extends Iterable<Tr>> RdfStream(T triples) {
        this((T)triples.iterator());
    }

    public <Tr extends Triple, T extends Collection<Tr>> RdfStream(T triples) {
        this((T)triples.iterator());
    }

    @SafeVarargs
    public <T extends Triple> RdfStream(T ... triples) {
        this((T)Iterators.forArray((Object[])triples));
    }

    @SafeVarargs
    public <T extends Statement> RdfStream(T ... statements) {
        this((T)Iterators.transform((Iterator)Iterators.forArray((Object[])statements), statement2triple));
    }

    public <T extends Triple> RdfStream(T triple) {
        this((T)Iterators.forArray((Object[])new Triple[]{triple}));
    }

    public RdfStream() {
        this((Triple)NONE);
    }

    public <Tr extends Triple, T extends Iterator<Tr>> RdfStream withThisContext(T stream) {
        return new RdfStream(stream).namespaces(this.namespaces()).topic(this.topic());
    }

    public <Tr extends Triple, T extends Iterable<Tr>> RdfStream withThisContext(T stream) {
        return new RdfStream(stream).namespaces(this.namespaces()).topic(this.topic());
    }

    public RdfStream concat(Iterator<? extends Triple> newTriples) {
        this.triples = Iterators.concat(this.triples, newTriples);
        return this;
    }

    public <T extends Triple> RdfStream concat(T newTriple) {
        this.triples = Iterators.concat(this.triples, (Iterator)Iterators.singletonIterator(newTriple));
        return this;
    }

    public <T extends Triple> RdfStream concat(T ... newTriples) {
        this.triples = Iterators.concat(this.triples, (Iterator)Iterators.forArray((Object[])newTriples));
        return this;
    }

    public RdfStream concat(Collection<? extends Triple> newTriples) {
        this.triples = Iterators.concat(this.triples, newTriples.iterator());
        return this;
    }

    public RdfStream limit(Integer limit) {
        return limit == -1 ? this : this.withThisContext(Iterators.limit((Iterator)((Object)this), (int)limit));
    }

    public RdfStream skip(Integer skipNum) {
        Iterators.advance((Iterator)((Object)this), (int)skipNum);
        return this;
    }

    public RdfStream filter(Predicate<? super Triple> predicate) {
        return this.withThisContext(Iterators.filter((Iterator)((Object)this), predicate));
    }

    public <ToType> Iterator<ToType> transform(Function<? super Triple, ToType> f) {
        return Iterators.transform((Iterator)((Object)this), f);
    }

    public RdfStream namespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
        return this;
    }

    public RdfStream namespaces(Map<String, String> nses) {
        this.namespaces.putAll(nses);
        return this;
    }

    public Session session() {
        return this.context;
    }

    public RdfStream session(Session session) {
        this.context = session;
        return this;
    }

    public Node topic() {
        return this.topic;
    }

    public RdfStream topic(Node topic) {
        this.topic = topic;
        return this;
    }

    public Model asModel() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefixes(this.namespaces());
        for (Triple t : this.iterable()) {
            model.add(model.asStatement(t));
        }
        return model;
    }

    public static RdfStream fromModel(Model model) {
        Iterator triples = Iterators.transform((Iterator)model.listStatements(), statement2triple);
        return new RdfStream(triples).namespaces(model.getNsPrefixMap());
    }

    protected Iterator<Triple> delegate() {
        return this.triples;
    }

    public Iterable<Triple> iterable() {
        return new Iterable<Triple>(){

            @Override
            public Iterator<Triple> iterator() {
                return RdfStream.this.triples;
            }
        };
    }

    public Map<String, String> namespaces() {
        return this.namespaces;
    }

    private static <T extends Triple> Function<T, Triple> cast() {
        return new Function<T, Triple>(){

            public Triple apply(T prototriple) {
                return prototriple;
            }
        };
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdfStream)) {
            return false;
        }
        RdfStream rdfo = (RdfStream)((Object)o);
        boolean triplesEqual = com.google.common.base.Objects.equal((Object)ImmutableSet.copyOf(rdfo.triples), (Object)ImmutableSet.copyOf(this.triples));
        boolean namespaceMappingsEqual = com.google.common.base.Objects.equal(rdfo.namespaces(), this.namespaces());
        boolean topicEqual = com.google.common.base.Objects.equal((Object)rdfo.topic(), (Object)this.topic());
        return triplesEqual && namespaceMappingsEqual && topicEqual;
    }

    public int hashCode() {
        return Objects.hash(this.namespaces(), this.triples, this.topic());
    }
}

