/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.utils.EventType;

public class FedoraEvent {
    private Event e;
    private Set<Integer> eventTypes = new HashSet<Integer>();
    private Set<String> eventProperties = new HashSet<String>();

    public FedoraEvent(Event e) {
        Preconditions.checkArgument((e != null ? 1 : 0) != 0, (Object)"null cannot support a FedoraEvent!");
        this.e = e;
    }

    public FedoraEvent(FedoraEvent e) {
        Preconditions.checkArgument((e != null ? 1 : 0) != 0, (Object)"null cannot support a FedoraEvent!");
        this.e = e.e;
    }

    public Set<Integer> getTypes() {
        return this.eventTypes != null ? Sets.union(Collections.singleton(this.e.getType()), this.eventTypes) : Collections.singleton(this.e.getType());
    }

    public FedoraEvent addType(Integer type) {
        this.eventTypes.add(type);
        return this;
    }

    public Set<String> getProperties() {
        return this.eventProperties;
    }

    public FedoraEvent addProperty(String property) {
        this.eventProperties.add(property);
        return this;
    }

    public String getPath() {
        return FedoraEvent.getPath(this.e);
    }

    public static String getPath(Event e) {
        try {
            if (e.getType() == 4 || e.getType() == 16 || e.getType() == 8) {
                return e.getPath().substring(0, e.getPath().lastIndexOf("/"));
            }
            return e.getPath();
        }
        catch (RepositoryException e1) {
            throw new RepositoryRuntimeException("Error getting event path!", e1);
        }
    }

    public String getUserID() {
        return this.e.getUserID();
    }

    public String getIdentifier() {
        try {
            return this.e.getIdentifier();
        }
        catch (RepositoryException e1) {
            throw new RepositoryRuntimeException("Error getting event identifier!", e1);
        }
    }

    public Map<Object, Object> getInfo() {
        try {
            return new HashMap<Object, Object>(this.e.getInfo());
        }
        catch (RepositoryException e1) {
            throw new RepositoryRuntimeException("Error getting event info!", e1);
        }
    }

    public String getUserData() {
        try {
            return this.e.getUserData();
        }
        catch (RepositoryException e1) {
            throw new RepositoryRuntimeException("Error getting event userData!", e1);
        }
    }

    public long getDate() {
        try {
            return this.e.getDate();
        }
        catch (RepositoryException e1) {
            throw new RepositoryRuntimeException("Error getting event date!", e1);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Event types:", (Object)Joiner.on((char)',').join(Iterables.transform(this.getTypes(), (Function)new Function<Integer, String>(){

            public String apply(Integer type) {
                return EventType.valueOf(type).getName();
            }
        }))).add("Event properties:", (Object)Joiner.on((char)',').join(this.eventProperties)).add("Path:", (Object)this.getPath()).add("Date: ", this.getDate()).add("Info:", this.getInfo()).toString();
    }
}

