/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services.functions;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.services.functions.JcrPropertyFunctions;

public abstract class BooleanTypesPredicate
implements Predicate<Node> {
    protected final Collection<String> nodeTypes;

    public BooleanTypesPredicate(String ... types) {
        this.nodeTypes = Arrays.asList(types);
    }

    public boolean apply(Node input) {
        if (input == null) {
            throw new IllegalArgumentException("null node passed to" + this.getClass().getName());
        }
        int matched = 0;
        try {
            if (JcrPropertyFunctions.isFrozen.apply((Object)input) && input.hasProperty("jcr:frozenMixinTypes")) {
                Iterator transform = Iterators.transform((Iterator)((Iterator)JcrPropertyFunctions.property2values.apply((Object)input.getProperty("jcr:frozenMixinTypes"))), JcrPropertyFunctions.value2string);
                while (transform.hasNext()) {
                    if (!this.nodeTypes.contains(transform.next())) continue;
                    ++matched;
                }
            } else {
                for (String nodeType : this.nodeTypes) {
                    if (!input.isNodeType(nodeType)) continue;
                    ++matched;
                }
            }
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this.test(matched);
    }

    protected abstract boolean test(int var1);
}

