/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JcrPropertyFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrPropertyFunctions.class);
    public static Function<NodeType, String> nodetype2name = new Function<NodeType, String>(){

        public String apply(NodeType t) {
            Preconditions.checkNotNull((Object)t, (Object)"null has no name!");
            return t.getName();
        }
    };
    public static Function<Value, String> value2string = new Function<Value, String>(){

        public String apply(Value v) {
            try {
                Preconditions.checkNotNull((Object)v, (Object)"null has no appropriate String representation!");
                return v.getString();
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Function<Property, Iterator<Value>> property2values = new Function<Property, Iterator<Value>>(){

        public Iterator<Value> apply(Property p) {
            try {
                if (p.isMultiple()) {
                    LOGGER.debug("Found multi-valued property: {}", (Object)p);
                    return Iterators.forArray((Object[])p.getValues());
                }
                LOGGER.debug("Found single-valued property: {}", (Object)p);
                return Iterators.forArray((Object[])new Value[]{p.getValue()});
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Property> isMultipleValuedProperty = new Predicate<Property>(){

        public boolean apply(Property p) {
            Preconditions.checkNotNull((Object)p, (Object)"null is neither multiple nor not multiple!");
            try {
                return p.isMultiple();
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Property> isBinaryContentProperty = new Predicate<Property>(){

        public boolean apply(Property p) {
            Preconditions.checkNotNull((Object)p, (Object)"null is neither binary nor not binary!");
            try {
                return p.getType() == 2 && p.getName().equals("jcr:data");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Node> isFrozen = new Predicate<Node>(){

        public boolean apply(Node node) {
            Preconditions.checkNotNull((Object)node, (Object)"null cannot be a Frozen node!");
            try {
                return node.isNodeType("nt:frozenNode");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };

    private JcrPropertyFunctions() {
    }
}

