/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.fcrepo.indexer.AbsentTransformPropertyException;
import org.fcrepo.indexer.Indexer;
import org.fcrepo.indexer.JcrXmlRetriever;
import org.fcrepo.indexer.NamedFieldsRetriever;
import org.fcrepo.indexer.RdfRetriever;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.utils.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerGroup
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexerGroup.class);
    @VisibleForTesting
    protected final Set<Indexer<Object>> indexers;
    private Set<URI> reindexed;
    static final String IDENTIFIER_HEADER_NAME = "org.fcrepo.jms.identifier";
    static final String PROPERTIES_HEADER_NAME = "org.fcrepo.jms.properties";
    static final String BASE_URL_HEADER_NAME = "org.fcrepo.jms.baseURL";
    static final String EVENT_TYPE_HEADER_NAME = "org.fcrepo.jms.eventType";
    static final String REMOVAL_EVENT_TYPE = "http://fedora.info/definitions/v4/repository#" + EventType.valueOf((Integer)2).toString();
    private static final String REINDEX_EVENT_TYPE = "http://fedora.info/definitions/v4/repository#NODE_REINDEXED";
    public static final String INDEXER_NAMESPACE = "http://fedora.info/definitions/v4/indexing#";
    public static final Property INDEXING_TRANSFORM_PREDICATE = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/indexing#hasIndexingTransformation");
    public static final Resource INDEXABLE_MIXIN = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/indexing#indexable");
    private static final String REST_PREFIX = "/rest/";
    private static final String FCREPO_PREFIX = "/fcrepo/";
    static final Resource DATASTREAM_TYPE = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#NonRdfSourceDescription");
    private static final Reader EMPTY_CONTENT = null;
    private final String fedoraUsername;
    private final String fedoraPassword;
    private final Map<String, DefaultHttpClient> clients;
    private final DefaultHttpClient defaultClient;

    public IndexerGroup(Set<Indexer<Object>> indexers, String fedoraUsername, String fedoraPassword) {
        this.fedoraUsername = fedoraUsername;
        this.fedoraPassword = fedoraPassword;
        LOGGER.debug("Creating IndexerGroup: {}", (Object)this);
        this.indexers = indexers;
        this.clients = new HashMap<String, DefaultHttpClient>();
        this.defaultClient = null;
    }

    public IndexerGroup(Set<Indexer<Object>> indexers, DefaultHttpClient httpClient) {
        LOGGER.debug("Creating IndexerGroup: {}", (Object)this);
        this.indexers = indexers;
        this.clients = new HashMap<String, DefaultHttpClient>();
        this.fedoraUsername = null;
        this.fedoraPassword = null;
        this.defaultClient = httpClient;
    }

    @VisibleForTesting
    protected DefaultHttpClient httpClient(String repositoryURL) {
        if (this.clients.size() > 0) {
            for (String base : this.clients.keySet()) {
                if (!repositoryURL.startsWith(base)) continue;
                return this.clients.get(base);
            }
        }
        if (this.defaultClient != null) {
            return this.defaultClient;
        }
        String baseURL = repositoryURL.indexOf(REST_PREFIX) > 0 ? repositoryURL.substring(0, repositoryURL.indexOf(REST_PREFIX) + REST_PREFIX.length()) : (repositoryURL.indexOf("/", FCREPO_PREFIX.length()) > 0 ? repositoryURL.substring(0, repositoryURL.indexOf("/", FCREPO_PREFIX.length()) + 1) : repositoryURL);
        PoolingClientConnectionManager connMann = new PoolingClientConnectionManager();
        connMann.setMaxTotal(Integer.MAX_VALUE);
        connMann.setDefaultMaxPerRoute(Integer.MAX_VALUE);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connMann);
        httpClient.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(0, false));
        if (!StringUtils.isBlank((String)this.fedoraUsername) && !StringUtils.isBlank((String)this.fedoraPassword)) {
            LOGGER.debug("Adding BASIC credentials to client for repo requests.");
            URI fedoraUri = URI.create(baseURL);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(fedoraUri.getHost(), fedoraUri.getPort()), (Credentials)new UsernamePasswordCredentials(this.fedoraUsername, this.fedoraPassword));
            httpClient.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        this.clients.put(baseURL, httpClient);
        return httpClient;
    }

    public void onMessage(Message message) {
        try {
            LOGGER.debug("Received message: {}", (Object)message.getJMSMessageID());
        }
        catch (JMSException e) {
            LOGGER.error("Received unintelligible message: {}", (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
        try {
            String eventType = message.getStringProperty(EVENT_TYPE_HEADER_NAME);
            String id = message.getStringProperty(IDENTIFIER_HEADER_NAME);
            String baseURL = message.getStringProperty(BASE_URL_HEADER_NAME);
            LOGGER.debug("Discovered id: {} in message.", (Object)id);
            LOGGER.debug("Discovered event type: {} in message.", (Object)eventType);
            LOGGER.debug("Discovered baseURL: {} in message.", (Object)baseURL);
            LOGGER.debug("Discovered properties: {} in message.", (Object)message.getStringProperty(PROPERTIES_HEADER_NAME));
            while (!Strings.isNullOrEmpty((String)baseURL) && baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            this.index(new URI(baseURL + id), eventType);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Error creating URI", (Throwable)e);
        }
        catch (JMSException e) {
            LOGGER.error("Error processing JMS event!", (Throwable)e);
        }
    }

    private void index(URI uri, String eventType) throws URISyntaxException {
        Boolean removal = REMOVAL_EVENT_TYPE.equals(eventType);
        DefaultHttpClient httpClient = this.httpClient(uri.toString());
        LOGGER.debug("It is {} that this is a removal operation.", (Object)removal);
        Supplier rdfr = Suppliers.memoize((Supplier)new RdfRetriever(uri, (HttpClient)httpClient));
        Supplier nfr = Suppliers.memoize((Supplier)new NamedFieldsRetriever(uri, (HttpClient)httpClient, (Supplier<Model>)rdfr));
        Supplier jcrfr = Suppliers.memoize((Supplier)new JcrXmlRetriever(uri, (HttpClient)httpClient));
        Boolean indexable = false;
        if (!removal.booleanValue()) {
            NodeIterator parents;
            Model rdf = (Model)rdfr.get();
            if (rdf.contains(ResourceFactory.createResource((String)uri.toString()), RDF.type, (RDFNode)INDEXABLE_MIXIN) || rdf.contains(ResourceFactory.createResource((String)(uri.toString() + "/" + "fcr:metadata")), RDF.type, (RDFNode)INDEXABLE_MIXIN)) {
                LOGGER.debug("Resource: {} retrieved with indexable type.", (Object)uri);
                indexable = true;
            } else {
                LOGGER.debug("Resource: {} retrieved without indexable type.", (Object)uri);
            }
            Resource subj = ResourceFactory.createResource((String)uri.toString());
            if (rdf.contains(subj, RDF.type, (RDFNode)DATASTREAM_TYPE) && uri.toString().indexOf("/fedora:system/") == -1 && (parents = rdf.listObjectsOfProperty(subj, RdfLexicon.HAS_PARENT)).hasNext()) {
                String parent = parents.nextNode().asResource().getURI();
                LOGGER.info("Datastream found, also indexing parent {}", (Object)parent);
                this.index(new URI(parent), "NODE_UPDATED");
            }
        }
        for (Indexer<Object> indexer : this.indexers) {
            LOGGER.debug("Operating for indexer: {}", indexer);
            Boolean hasContent = false;
            Object content = EMPTY_CONTENT;
            if (!removal.booleanValue() && indexable.booleanValue()) {
                switch (indexer.getIndexerType()) {
                    case NAMEDFIELDS: {
                        LOGGER.debug("Retrieving named fields for: {}, (may be cached) to index to {}...", (Object)uri, indexer);
                        try {
                            content = nfr.get();
                            hasContent = true;
                        }
                        catch (AbsentTransformPropertyException e) {
                            LOGGER.error("Failed to retrieve indexable content:could not find transform property!");
                            hasContent = false;
                        }
                        break;
                    }
                    case RDF: {
                        LOGGER.debug("Retrieving RDF for: {}, (may be cached) to index to {}...", (Object)uri, indexer);
                        content = rdfr.get();
                        hasContent = true;
                        break;
                    }
                    case JCRXML_PERSISTENCE: {
                        LOGGER.debug("Retrieving jcr/xml for: {} and persist it to {}...", (Object)uri, indexer);
                        content = jcrfr.get();
                        hasContent = true;
                        break;
                    }
                    default: {
                        hasContent = true;
                    }
                }
            }
            try {
                if (removal.booleanValue()) {
                    LOGGER.debug("Executing removal of: {} to indexer: {}...", (Object)uri, indexer);
                    indexer.remove(uri);
                    continue;
                }
                if (hasContent.booleanValue()) {
                    LOGGER.debug("Executing update of: {} to indexer: {}...", (Object)uri, indexer);
                    indexer.update(uri, content);
                    continue;
                }
                if (!indexable.booleanValue()) continue;
                LOGGER.error("Received update for: {} but was unable to retrieve content for update to indexer: {}!", (Object)uri, indexer);
            }
            catch (Exception e) {
                LOGGER.error("Error {} indexing {}: {}!", new Object[]{indexer.getClass().getName(), uri, e});
            }
        }
    }

    public void reindex(URI uri, boolean recursive) throws URISyntaxException {
        this.reindexed = new HashSet<URI>();
        this.reindexURI(uri, recursive);
    }

    private void reindexURI(URI uri, boolean recursive) throws URISyntaxException {
        LOGGER.debug("Reindexing {}, recursive: {}", (Object)uri, (Object)recursive);
        if (!this.reindexed.contains(uri)) {
            this.index(uri, REINDEX_EVENT_TYPE);
        }
        this.reindexed.add(uri);
        if (recursive) {
            Supplier rdfr = Suppliers.memoize((Supplier)new RdfRetriever(uri, (HttpClient)this.httpClient(uri.toString())));
            Model model = (Model)rdfr.get();
            NodeIterator children = model.listObjectsOfProperty(RdfLexicon.CONTAINS);
            while (children.hasNext()) {
                URI child = new URI(children.nextNode().asResource().getURI());
                if (this.reindexed.contains(child)) continue;
                this.reindexURI(child, true);
            }
        }
    }
}

