/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.fcrepo.indexer.NamedFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedFieldsDeserializer
extends TypeAdapter<NamedFields> {
    private static final Type type = new TypeToken<List<Map<String, JsonElement>>>(){}.getType();
    private Gson gson;
    public static final Long INDEX_TIME_BOOST = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedFieldsDeserializer.class);
    private static Function<JsonElement, Collection<String>> jsonElement2list = new Function<JsonElement, Collection<String>>(){

        public List<String> apply(JsonElement input) {
            JsonElement json = (JsonElement)Preconditions.checkNotNull((Object)input, (Object)"Cannot transform null!");
            ImmutableList.Builder b = ImmutableList.builder();
            for (JsonElement value : json.getAsJsonArray()) {
                b.add((Object)value.getAsString());
            }
            return b.build();
        }
    };

    public void write(JsonWriter out, NamedFields value) throws IOException {
        throw new UnsupportedOperationException();
    }

    public NamedFields read(JsonReader in) throws IOException {
        try {
            List fields = (List)this.gson.fromJson(in, type);
            return new NamedFields(Maps.transformValues((Map)((Map)fields.get(0)), jsonElement2list));
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse JSON to List<Map<String, Collection<String>>>!", (Throwable)e);
            throw e;
        }
    }

    public NamedFieldsDeserializer setGson(Gson gson) {
        this.gson = gson;
        return this;
    }
}

