/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import javax.ws.rs.core.Link;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfRetriever
implements Supplier<Model> {
    private static final String RDF_SERIALIZATION = "text/rdf+n3";
    private final URI identifier;
    private final HttpClient httpClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(RdfRetriever.class);

    public RdfRetriever(URI identifier, HttpClient client) {
        this.identifier = identifier;
        this.httpClient = client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Model get() {
        try {
            HttpHead headRequest = new HttpHead(this.identifier);
            HttpResponse headResponse = this.httpClient.execute((HttpUriRequest)headRequest);
            URI descriptionURI = null;
            Header[] links = headResponse.getHeaders("Link");
            if (links != null) {
                for (Header h : headResponse.getHeaders("Link")) {
                    Link link = Link.valueOf((String)h.getValue());
                    if (!link.getRel().equals("describedby")) continue;
                    descriptionURI = link.getUri();
                    LOGGER.debug("Using URI from Link header: {}", (Object)descriptionURI);
                }
            }
            if (descriptionURI == null) {
                descriptionURI = this.identifier;
            }
            HttpGet request = new HttpGet(descriptionURI);
            request.addHeader("Accept", RDF_SERIALIZATION);
            LOGGER.debug("Retrieving RDF content from: {}...", (Object)request.getURI());
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) throw new HttpException(response.getStatusLine().toString());
            try (InputStreamReader r = new InputStreamReader(response.getEntity().getContent(), "UTF8");){
                Model model = ModelFactory.createDefaultModel().read((Reader)r, "", "N3");
                return model;
            }
        }
        catch (IOException | HttpException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

