/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer.persistence;

import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang.StringUtils;
import org.fcrepo.indexer.SynchIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePersistenceIndexer<Content, File>
extends SynchIndexer<Content, File> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePersistenceIndexer.class);
    private final String pathName;
    private final String extension;

    public BasePersistenceIndexer(String pathName, String extension) {
        this.pathName = pathName;
        this.extension = extension;
    }

    protected Path pathFor(URI id) throws IOException {
        String fullPath = id.toString().substring(id.toString().indexOf("//") + 2);
        fullPath = org.apache.commons.lang3.StringUtils.substringBefore((String)fullPath, (String)"/").replace(":", "/") + "/" + org.apache.commons.lang3.StringUtils.substringAfter((String)fullPath, (String)"/");
        String idPath = URLEncoder.encode(StringUtils.substringAfterLast((String)fullPath, (String)"/"), "UTF-8");
        String[] pathTokens = org.apache.commons.lang3.StringUtils.substringBeforeLast((String)fullPath, (String)"/").split("/");
        StringBuilder pathBuilder = new StringBuilder();
        for (String token : pathTokens) {
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)token)) continue;
            pathBuilder.append(URLEncoder.encode(token, "UTF-8") + "/");
        }
        fullPath = pathBuilder.substring(0, pathBuilder.length() - 1).toString();
        Path dir = Paths.get(this.pathName, fullPath);
        if (Files.notExists(dir, LinkOption.NOFOLLOW_LINKS)) {
            Files.createDirectories(Paths.get(this.pathName, fullPath), new FileAttribute[0]);
        }
        return Paths.get(dir.toString(), idPath + this.extension);
    }
}

