/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.fcrepo.indexer.Indexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsynchIndexer<Content, Result>
implements Indexer<Content> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsynchIndexer.class);

    public abstract ListeningExecutorService executorService();

    @Override
    public ListenableFuture<Result> update(URI identifier, Content content) throws IOException {
        LOGGER.debug("Received update for identifier: {}", (Object)identifier);
        ListenableFutureTask task = ListenableFutureTask.create(this.updateSynch(identifier, content));
        task.addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.notifyAll();
                }
            }
        }, (Executor)this.executorService());
        this.executorService().submit((Runnable)task);
        LOGGER.debug("Issued task to execution pool for identifier: {}", (Object)identifier);
        return task;
    }

    @Override
    public ListenableFuture<Result> remove(URI identifier) throws IOException {
        LOGGER.debug("Received remove for identifier: {}", (Object)identifier);
        ListenableFutureTask task = ListenableFutureTask.create(this.removeSynch(identifier));
        task.addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    this.notifyAll();
                }
            }
        }, (Executor)this.executorService());
        this.executorService().submit((Runnable)task);
        return task;
    }

    public abstract Callable<Result> removeSynch(URI var1);

    public abstract Callable<Result> updateSynch(URI var1, Content var2);
}

