/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fcrepo.indexer.Indexer;
import org.fcrepo.indexer.NamedFields;
import org.fcrepo.indexer.SynchIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSerializer
extends SynchIndexer<NamedFields, File> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSerializer.class);
    private static SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
    private File path;

    public void setPath(String pathName) {
        this.path = new File(pathName);
        if (!this.path.exists()) {
            this.path.mkdirs();
        }
    }

    public String getPath() {
        return this.path.getAbsolutePath();
    }

    @Override
    public Callable<File> updateSynch(URI id, final NamedFields content) {
        if (id.toString().endsWith("/")) {
            throw new IllegalArgumentException("Identifiers for use with this indexer may not end in '/'!");
        }
        String fn = id.toString() + "@" + fmt.format(new Date());
        if (fn.indexOf(47) != -1) {
            fn = StringUtils.substringAfterLast((String)fn, (String)"/");
        }
        final File file = new File(this.path, fn);
        LOGGER.debug("Updating to file: {}", (Object)file);
        return new Callable<File>(){

            @Override
            public File call() {
                try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");){
                    if (content.isEmpty()) {
                        w.write("");
                    } else {
                        w.write(content.toString());
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to write to file: {}", (Object)file);
                    Throwables.propagate((Throwable)e);
                }
                return file;
            }
        };
    }

    @Override
    public Callable<File> removeSynch(URI id) {
        LOGGER.debug("Received remove for identifier: {}", (Object)id);
        return this.updateSynch(id, new NamedFields());
    }

    @Override
    public Indexer.IndexerType getIndexerType() {
        return Indexer.IndexerType.NAMEDFIELDS;
    }
}

