/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.Link;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrXmlRetriever
implements Supplier<InputStream> {
    private final URI identifier;
    private final HttpClient httpClient;
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrXmlRetriever.class);

    public JcrXmlRetriever(URI identifier, HttpClient client) {
        this.identifier = identifier;
        this.httpClient = client;
    }

    public InputStream get() {
        try {
            HttpHead headRequest = new HttpHead(this.identifier);
            HttpResponse headResponse = this.httpClient.execute((HttpUriRequest)headRequest);
            URI descriptionURI = null;
            Header[] links = headResponse.getHeaders("Link");
            if (links != null) {
                for (Header h : headResponse.getHeaders("Link")) {
                    Link link = Link.valueOf((String)h.getValue());
                    if (!link.getRel().equals("describedby")) continue;
                    descriptionURI = link.getUri();
                    LOGGER.debug("Using URI from Link header: {}", (Object)descriptionURI);
                }
            }
            if (descriptionURI == null) {
                descriptionURI = this.identifier;
            }
            HttpGet request = new HttpGet(descriptionURI.toString() + "/fcr:export?skipBinary=true");
            LOGGER.debug("Retrieving jcr/xml content from: {}...", (Object)request.getURI());
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                return response.getEntity().getContent();
            }
            throw new HttpException(response.getStatusLine().getStatusCode() + " : " + EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (IOException | HttpException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

