/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import javax.ws.rs.core.Link;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.fcrepo.indexer.AbsentTransformPropertyException;
import org.fcrepo.indexer.IndexerGroup;
import org.fcrepo.indexer.NamedFields;
import org.fcrepo.indexer.NamedFieldsDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedFieldsRetriever
implements Supplier<NamedFields> {
    private final URI uri;
    private final HttpClient httpClient;
    private final Supplier<Model> rdfr;
    private Gson gson;
    private static final Type typeToken = new TypeToken<NamedFields>(){}.getType();
    private static final Logger LOGGER = LoggerFactory.getLogger(NamedFieldsRetriever.class);

    public NamedFieldsRetriever(URI uri, HttpClient client, Supplier<Model> rdfr) {
        this.uri = uri;
        this.httpClient = client;
        this.rdfr = rdfr;
        NamedFieldsDeserializer deserializer = new NamedFieldsDeserializer();
        this.gson = new GsonBuilder().registerTypeAdapter(typeToken, (Object)deserializer).create();
        deserializer.setGson(this.gson);
    }

    public NamedFields get() {
        LOGGER.debug("Retrieving RDF representation for: {}", (Object)this.uri);
        try {
            Model rdf = (Model)this.rdfr.get();
            if (!rdf.contains(ResourceFactory.createResource((String)this.uri.toString()), IndexerGroup.INDEXING_TRANSFORM_PREDICATE)) {
                LOGGER.info("Looking up property locating LDPath transform for: {}", (Object)this.uri);
                HttpHead headRequest = new HttpHead(this.uri);
                HttpResponse headResponse = this.httpClient.execute((HttpUriRequest)headRequest);
                URI descriptionURI = null;
                Header[] links = headResponse.getHeaders("Link");
                if (links != null) {
                    for (Header h : headResponse.getHeaders("Link")) {
                        Link link = Link.valueOf((String)h.getValue());
                        if (!link.getRel().equals("describedby")) continue;
                        descriptionURI = link.getUri();
                        LOGGER.debug("Using URI from Link header: {}", (Object)descriptionURI);
                    }
                }
                if (descriptionURI == null) {
                    throw new AbsentTransformPropertyException("Property lookup failed for uri: " + this.uri);
                }
                return this.getNamedFields(rdf, descriptionURI);
            }
            return this.getNamedFields(rdf, this.uri);
        }
        catch (IOException | HttpException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private NamedFields getNamedFields(Model rdf, URI uri) throws IOException, HttpException {
        NodeIterator nodeIterator = rdf.listObjectsOfProperty(ResourceFactory.createResource((String)uri.toString()), IndexerGroup.INDEXING_TRANSFORM_PREDICATE);
        if (!nodeIterator.hasNext()) {
            throw new AbsentTransformPropertyException("Property lookup failed for uri: " + uri);
        }
        RDFNode indexingTransform = nodeIterator.next();
        String transformKey = indexingTransform.asLiteral().getString();
        LOGGER.debug("Discovered transform key: {}", (Object)transformKey);
        HttpGet transformedResourceRequest = new HttpGet(uri.toString() + "/fcr:transform/" + transformKey);
        LOGGER.debug("Retrieving transformed resource from: {}", (Object)transformedResourceRequest.getURI());
        HttpResponse response = this.httpClient.execute((HttpUriRequest)transformedResourceRequest);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new HttpException(response.getStatusLine().toString());
        }
        try (InputStreamReader r = new InputStreamReader(response.getEntity().getContent(), "UTF8");){
            NamedFields namedFields = (NamedFields)this.gson.fromJson((Reader)r, typeToken);
            return namedFields;
        }
    }
}

