/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.indexer.persistence;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.fcrepo.indexer.Indexer;
import org.fcrepo.indexer.persistence.BasePersistenceIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrXmlPersistenceIndexer
extends BasePersistenceIndexer<InputStream, File> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrXmlPersistenceIndexer.class);

    public JcrXmlPersistenceIndexer(String pathName) {
        super(pathName, ".jcr.xml");
    }

    @Override
    public Callable<File> updateSynch(final URI id, final InputStream content) {
        if (id.toString().endsWith("/")) {
            throw new IllegalArgumentException("Identifiers for use with this indexer may not end in '/'!");
        }
        return new Callable<File>(){

            @Override
            public File call() throws IOException {
                Path p = JcrXmlPersistenceIndexer.this.pathFor(id);
                LOGGER.debug("Updating {} to file: {}", (Object)id, (Object)p.toAbsolutePath().toString());
                Files.copy(content, p, new CopyOption[0]);
                return p.toFile();
            }
        };
    }

    @Override
    public Callable<File> removeSynch(URI id) {
        LOGGER.debug("Received remove for identifier: {}", (Object)id);
        return this.updateSynch(id, new ByteArrayInputStream("".getBytes()));
    }

    @Override
    public Indexer.IndexerType getIndexerType() {
        return Indexer.IndexerType.JCRXML_PERSISTENCE;
    }
}

